/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.infrastructure.AbstractPowerConsumingResource;
import de.fzi.power.infrastructure.PowerConsumingResourceSet;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.interpreter.PowerModelRegistryChangeListener;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.metricspec.MetricDescription;

public class PowerModelRegistry
extends AbstractObservable<PowerModelRegistryChangeListener> {
    private final HashMap<AbstractPowerConsumingResource, IResourcePowerModelCalculator> calculatorsPerResource = new HashMap();
    private final HashMap<PowerProvidingEntity, AbstractDistributionPowerModelCalculator> calculatorsPerPdu = new HashMap();

    public void updateResourcePowerModel(PowerConsumingResourceSet powerConsumingResource, IResourcePowerModelCalculator resourceCalculator) {
        if (resourceCalculator == null || powerConsumingResource == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (!this.calculatorsPerResource.containsKey(powerConsumingResource) || !this.calculatorsPerResource.get(powerConsumingResource).equals(resourceCalculator)) {
            this.calculatorsPerResource.put((AbstractPowerConsumingResource)powerConsumingResource, resourceCalculator);
            ((PowerModelRegistryChangeListener)this.getEventDispatcher()).resourcePowerModelChanged(resourceCalculator, (AbstractPowerConsumingResource)powerConsumingResource);
        }
    }

    public void updateStatefulPowerConsumingResource(StatefulPowerConsumingResourceSet powerConsumingResource, IResourcePowerModelCalculator resourceCalculator) {
        if (!this.calculatorsPerResource.containsKey(powerConsumingResource) || !this.calculatorsPerResource.get(powerConsumingResource).equals(resourceCalculator)) {
            this.calculatorsPerResource.put((AbstractPowerConsumingResource)powerConsumingResource, resourceCalculator);
            ((PowerModelRegistryChangeListener)this.getEventDispatcher()).resourcePowerModelChanged(resourceCalculator, (AbstractPowerConsumingResource)powerConsumingResource);
        }
    }

    public void updateDistributionPowerModel(PowerProvidingEntity ppe, AbstractDistributionPowerModelCalculator pduCalculator) {
        if (pduCalculator == null || ppe == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (!this.calculatorsPerPdu.containsKey(ppe) || !this.calculatorsPerPdu.get(ppe).equals(pduCalculator)) {
            this.calculatorsPerPdu.put(ppe, pduCalculator);
            ((PowerModelRegistryChangeListener)this.getEventDispatcher()).distributionPowerModelChanged(pduCalculator, ppe);
        }
    }

    public IResourcePowerModelCalculator getCalculator(AbstractPowerConsumingResource resource) {
        return this.calculatorsPerResource.get(Objects.requireNonNull(resource));
    }

    public AbstractDistributionPowerModelCalculator getCalculator(PowerProvidingEntity entity) {
        return this.calculatorsPerPdu.get(Objects.requireNonNull(entity));
    }

    public Map<AbstractPowerConsumingResource, Set<MetricDescription>> getRequiredMetricsForRegisteredCalculators() {
        return this.calculatorsPerResource.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(e -> (AbstractPowerConsumingResource)e.getKey(), e -> ((IResourcePowerModelCalculator)e.getValue()).getInputMetrics()), Collections::unmodifiableMap));
    }
}

