/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators;

import de.fzi.power.binding.DistributionPowerBinding;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.CalculatorFactory;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import de.fzi.power.specification.BlackBoxDistributionPowerModelSpecification;
import de.fzi.power.specification.BlackBoxResourcePowerModelSpecification;
import de.fzi.power.specification.PowerModelSpecification;
import de.fzi.power.specification.util.SpecificationSwitch;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractCalculatorFactory
implements CalculatorFactory {
    private SpecificationSwitch<Boolean> SUPPORTED_POWERMODELS_SWITCH = new SpecificationSwitch<Boolean>(){

        public Boolean caseBlackBoxDistributionPowerModelSpecification(BlackBoxDistributionPowerModelSpecification object) {
            return AbstractCalculatorFactory.this.getSupportedDistributionPowerModelIds().contains(object.getId());
        }

        public Boolean caseBlackBoxResourcePowerModelSpecification(BlackBoxResourcePowerModelSpecification object) {
            return AbstractCalculatorFactory.this.getSupportedResourcePowerModelIds().contains(object.getId());
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }
    };

    @Override
    public boolean isCompatibleWith(PowerModelSpecification specification) {
        return (Boolean)this.SUPPORTED_POWERMODELS_SWITCH.doSwitch((EObject)specification);
    }

    @Override
    public abstract int getPriority();

    @Override
    public AbstractDistributionPowerModelCalculator instantiateDistributionPowerModelCalculator(DistributionPowerBinding binding) {
        throw new UnsupportedOperationException("This calculator factory does not support the instantiation of distribution power model calculators");
    }

    @Override
    public IResourcePowerModelCalculator instantiateResourcePowerModelCalculator(ResourcePowerBinding binding) {
        throw new UnsupportedOperationException("This calculator factory does not support the instantiation of resource power model calculators");
    }

    protected Set<String> getSupportedDistributionPowerModelIds() {
        return Collections.emptySet();
    }

    protected Set<String> getSupportedResourcePowerModelIds() {
        return Collections.emptySet();
    }
}

