/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.interpreter.AbstractEvaluationScope;
import de.fzi.power.interpreter.InterpreterUtils;
import de.fzi.power.interpreter.measureprovider.ExtendedMeasureProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public final class EvaluationScope
extends AbstractEvaluationScope {
    private final Map<ProcessingResourceSpecification, Set<IDataSource>> availableMeasurements = InterpreterUtils.createIdentifierMatchingHashMap();
    private final Set<ExtendedMeasureProvider> extendedMeasureProviders = new HashSet<ExtendedMeasureProvider>();

    private EvaluationScope() {
    }

    public static EvaluationScope createScope(Iterable<IDataSource> experimentMeasurements, Collection<ExtendedMeasureProvider> extendedMeasureProviders) {
        Objects.requireNonNull(experimentMeasurements, "Experiment measurements must be null.");
        EvaluationScope scope = new EvaluationScope();
        for (IDataSource source : experimentMeasurements) {
            ProcessingResourceSpecification spec = InterpreterUtils.getProcessingResourceSpecificationFromMeasuringPoint(source.getMeasuringPoint());
            if (spec == null) continue;
            Set<IDataSource> sources = scope.availableMeasurements.get(spec);
            if (sources == null) {
                sources = new HashSet<IDataSource>();
                scope.availableMeasurements.put(spec, sources);
                scope.resourceMeasurements.put(spec, new HashSet());
            }
            sources.add(source);
        }
        scope.extendedMeasureProviders.addAll(Objects.requireNonNull(extendedMeasureProviders, "Collection of extended measure providers must not be null."));
        scope.reset();
        return scope;
    }

    @Override
    public void reset() {
        this.iterator = this.iterator();
    }

    @Override
    public void setResourceMetricsToEvaluate(Map<ProcessingResourceSpecification, Set<MetricDescription>> metricsMap) {
        Objects.requireNonNull(metricsMap, "Given map must not be null.");
        for (Map.Entry<ProcessingResourceSpecification, Set<MetricDescription>> entry : metricsMap.entrySet()) {
            Set<IDataSource> availableSourcesForResource = this.availableMeasurements.getOrDefault(entry.getKey(), Collections.emptySet());
            Map<MetricDescription, IDataSource> availableDataExtended = InterpreterUtils.determineDataSourcesForAvailableMetrics(availableSourcesForResource, this.extendedMeasureProviders);
            Set<MetricDescription> extendedMetricSet = availableDataExtended.keySet();
            for (MetricDescription soughtFor : entry.getValue()) {
                MetricDescription description = extendedMetricSet.stream().filter(metricDesc -> InterpreterUtils.isRequiredMetricSatisfiedBy(soughtFor, metricDesc)).findFirst().orElseThrow(() -> new IllegalArgumentException("No data source available for processing resource '" + ((ProcessingResourceSpecification)entry.getKey()).getId() + "' for the metric: " + soughtFor.getName()));
                ((Set)this.resourceMeasurements.get(entry.getKey())).add(availableDataExtended.get(description).getDataStream());
            }
        }
        this.reset();
    }
}

