/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.infrastructure.PowerConsumingEntity;
import de.fzi.power.infrastructure.PowerConsumingResourceSet;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.infrastructure.util.InfrastructureSwitch;
import de.fzi.power.interpreter.measureprovider.ExtendedMeasureProvider;
import de.uka.ipd.sdq.identifier.Identifier;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.ResourceURIMeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.util.MeasuringpointSwitch;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentSwitch;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;

public final class InterpreterUtils {
    private static final PcmmeasuringpointSwitch<ProcessingResourceSpecification> PCMMEASURINGPOINT_SWITCH = new PcmmeasuringpointSwitch<ProcessingResourceSpecification>(){

        public ProcessingResourceSpecification caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint point) {
            return point.getActiveResource();
        }

        public ProcessingResourceSpecification defaultCase(EObject eObject) {
            return (ProcessingResourceSpecification)MEASURINGPOINT_SWITCH.doSwitch(eObject);
        }
    };
    private static final MeasuringpointSwitch<ProcessingResourceSpecification> MEASURINGPOINT_SWITCH = new MeasuringpointSwitch<ProcessingResourceSpecification>(){

        public ProcessingResourceSpecification caseResourceURIMeasuringPoint(ResourceURIMeasuringPoint point) {
            URI resourceUri = URI.createURI((String)point.getResourceURI());
            if (resourceUri.hasFragment()) {
                return (ProcessingResourceSpecification)RESOURCEENV_SWITCH.doSwitch(Optional.ofNullable(point.eResource()).map(Resource::getResourceSet).map(rs -> EMFLoadHelper.loadAndResolveEObject((ResourceSet)rs, (URI)resourceUri)).orElseGet(() -> EMFLoadHelper.loadAndResolveEObject((String)point.getResourceURI())));
            }
            return null;
        }
    };
    private static final ResourceenvironmentSwitch<ProcessingResourceSpecification> RESOURCEENV_SWITCH = new ResourceenvironmentSwitch<ProcessingResourceSpecification>(){

        public ProcessingResourceSpecification caseProcessingResourceSpecification(ProcessingResourceSpecification proc) {
            return proc;
        }
    };
    private static final InfrastructureSwitch<Set<ProcessingResourceSpecification>> INFRASTRUCTURE_SWITCH = new InfrastructureSwitch<Set<ProcessingResourceSpecification>>(){

        public Set<ProcessingResourceSpecification> casePowerProvidingEntity(PowerProvidingEntity ppe) {
            HashSet<ProcessingResourceSpecification> result = new HashSet<ProcessingResourceSpecification>();
            for (PowerConsumingEntity dist : ppe.getNestedPowerConsumingEntities()) {
                result.addAll((Collection)this.doSwitch((EObject)dist));
            }
            return result;
        }

        public Set<ProcessingResourceSpecification> casePowerConsumingResourceSet(PowerConsumingResourceSet resource) {
            return Collections.singleton((ProcessingResourceSpecification)resource.getProcessingResourceSpecifications().get(0));
        }

        public Set<ProcessingResourceSpecification> caseStatefulPowerConsumingResourceSet(StatefulPowerConsumingResourceSet resource) {
            return Collections.singleton((ProcessingResourceSpecification)resource.getProcessingResourceSpecifications().get(0));
        }

        public Set<ProcessingResourceSpecification> defaultCase(EObject obj) {
            return Collections.emptySet();
        }
    };

    public static ProcessingResourceSpecification getProcessingResourceSpecificationFromMeasuringPoint(MeasuringPoint measuringPoint) {
        return (ProcessingResourceSpecification)PCMMEASURINGPOINT_SWITCH.doSwitch((EObject)Objects.requireNonNull(measuringPoint, "Given measuring point must not be null."));
    }

    public static Set<ProcessingResourceSpecification> getProcessingResourceSpecsFromInfrastructureElement(EObject infModelElement) {
        return (Set)INFRASTRUCTURE_SWITCH.doSwitch(Objects.requireNonNull(infModelElement, "Given EObject must not be null."));
    }

    public static PowerProvidingEntity getPowerProvidingEntityFromMeasuringPoint(final ResourceSet resourceSet, MeasuringPoint measuringPoint) {
        if (measuringPoint == null) {
            throw new IllegalArgumentException("Given MeasuringPoint must not be null.");
        }
        return (PowerProvidingEntity)new MeasuringpointSwitch<PowerProvidingEntity>(){
            private final InfrastructureSwitch<PowerProvidingEntity> infSwitch = new InfrastructureSwitch<PowerProvidingEntity>(){

                public PowerProvidingEntity casePowerProvidingEntity(PowerProvidingEntity ppe) {
                    return ppe;
                }
            };

            public PowerProvidingEntity caseResourceURIMeasuringPoint(ResourceURIMeasuringPoint mp) {
                URI resourceUri = URI.createURI((String)mp.getResourceURI());
                if (resourceUri.hasFragment()) {
                    return (PowerProvidingEntity)this.infSwitch.doSwitch(Optional.ofNullable(resourceSet).map(rs -> EMFLoadHelper.loadAndResolveEObject((ResourceSet)resourceSet, (URI)resourceUri)).orElseGet(() -> EMFLoadHelper.loadAndResolveEObject((String)mp.getResourceURI())));
                }
                return null;
            }
        }.doSwitch((EObject)measuringPoint);
    }

    public static boolean isRequiredMetricSatisfiedBy(MetricDescription required, MetricDescription available) {
        boolean result;
        block3: {
            block5: {
                block4: {
                    block2: {
                        result = false;
                        if (!MetricSpecPackage.eINSTANCE.getMetricSetDescription().isInstance((Object)required)) break block2;
                        MetricSetDescription requiredSet = (MetricSetDescription)required;
                        result = true;
                        for (MetricDescription subsumedMetric : requiredSet.getSubsumedMetrics()) {
                            result &= InterpreterUtils.isRequiredMetricSatisfiedBy(subsumedMetric, available);
                        }
                        break block3;
                    }
                    if (!required.equals(available)) break block4;
                    result = true;
                    break block3;
                }
                if (!required.getId().equals(available.getId())) break block5;
                result = true;
                break block3;
            }
            if (!MetricSpecPackage.eINSTANCE.getMetricSetDescription().isInstance((Object)available)) break block3;
            MetricSetDescription availableSet = (MetricSetDescription)available;
            for (MetricDescription desc : availableSet.getSubsumedMetrics()) {
                result |= InterpreterUtils.isRequiredMetricSatisfiedBy(required, desc);
            }
        }
        return result;
    }

    public static <K extends Identifier, V> Map<K, V> createIdentifierMatchingHashMap() {
        return new IdentifierMatchingMapDecorator(new HashMap(), new HashMap());
    }

    public static <K extends Identifier, V> Map<K, V> createIdentifierMatchingHashMap(int size) {
        return new IdentifierMatchingMapDecorator(new HashMap(size), new HashMap(size));
    }

    public static Map<MetricDescription, IDataSource> determineDataSourcesForAvailableMetrics(Set<IDataSource> dataSources, Set<ExtendedMeasureProvider> measureProviders) {
        int oldSize;
        Map<MetricDescription, IDataSource> metricToDataSource = InterpreterUtils.createIdentifierMatchingHashMap();
        for (IDataSource inputSource : dataSources) {
            metricToDataSource.put(inputSource.getMetricDesciption(), inputSource);
        }
        do {
            oldSize = metricToDataSource.size();
            for (ExtendedMeasureProvider provider : measureProviders) {
                for (MetricDescription m : provider.getTargetMetrics()) {
                    if (metricToDataSource.containsKey(m) || !provider.canProvideMetric(m, metricToDataSource.keySet())) continue;
                    metricToDataSource.put(m, provider.getDataSource(new HashSet<IDataSource>(metricToDataSource.values())));
                }
            }
        } while (metricToDataSource.size() > oldSize);
        return Collections.unmodifiableMap(metricToDataSource);
    }

    private static class IdentifierMatchingMapDecorator<K extends Identifier, V>
    implements Map<K, V> {
        private final Map<String, V> decoratedMap;
        private final Map<String, K> keyMap;

        private IdentifierMatchingMapDecorator(Map<String, V> decoratedMap, Map<String, K> keyMap) {
            this.decoratedMap = decoratedMap;
            this.keyMap = keyMap;
        }

        @Override
        public int size() {
            return this.decoratedMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.decoratedMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null || !(key instanceof Identifier)) {
                return false;
            }
            return this.decoratedMap.containsKey(((Identifier)key).getId());
        }

        @Override
        public boolean containsValue(Object value) {
            return this.decoratedMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (key == null || !(key instanceof Identifier)) {
                return null;
            }
            return this.decoratedMap.get(((Identifier)key).getId());
        }

        @Override
        public V put(K key, V value) {
            if (key == null || !(key instanceof Identifier)) {
                return null;
            }
            this.keyMap.put(key.getId(), (String)key);
            return this.decoratedMap.put(key.getId(), value);
        }

        @Override
        public V remove(Object key) {
            if (key == null || !(key instanceof Identifier)) {
                return null;
            }
            this.keyMap.remove(((Identifier)key).getId());
            return this.decoratedMap.remove(((Identifier)key).getId());
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put((K)((Identifier)entry.getKey()), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.keyMap.clear();
            this.decoratedMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return new HashSet<K>(this.keyMap.values());
        }

        @Override
        public Collection<V> values() {
            return this.decoratedMap.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            HashSet<Map.Entry<K, V>> resultSet = new HashSet<Map.Entry<K, V>>();
            for (Map.Entry<String, K> entry : this.keyMap.entrySet()) {
                resultSet.add(new AbstractMap.SimpleEntry<Identifier, V>((Identifier)entry.getValue(), this.decoratedMap.get(entry.getKey())));
            }
            return resultSet;
        }
    }
}

