/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.measureprovider;

import de.fzi.power.interpreter.InterpreterUtils;
import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.metricspec.MetricDescription;

public abstract class ExtendedMeasureProvider
implements IPropertyConfigurable {
    public abstract Collection<Set<MetricDescription>> getSourceMetrics();

    protected abstract Collection<Set<String>> getSourceMetricIds();

    public abstract Set<MetricDescription> getTargetMetrics();

    public abstract IDataSource getDataSource(Set<IDataSource> var1);

    public boolean canProvideMetric(MetricDescription desiredMetric, Collection<MetricDescription> availableSourceMetrics) {
        Objects.requireNonNull(desiredMetric, "Desired target metric must not be null.");
        Objects.requireNonNull(availableSourceMetrics, "Set of available source metrics must not be null.");
        if (this.getSourceMetrics().isEmpty()) {
            return true;
        }
        if (this.getTargetMetrics().stream().anyMatch(metric -> InterpreterUtils.isRequiredMetricSatisfiedBy(desiredMetric, metric))) {
            Collection metricIds = availableSourceMetrics.stream().map(Identifier::getId).collect(Collectors.toList());
            return this.getSourceMetricIds().stream().anyMatch(metricIds::containsAll);
        }
        return false;
    }
}

