/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.interpreter.EvaluationScopeIterator;
import de.fzi.power.interpreter.InterpreterUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public abstract class AbstractEvaluationScope
implements Iterable<Map<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>>> {
    private static final MetricDescription POINT_IN_TIME_METRIC = MetricDescriptionConstants.POINT_IN_TIME_METRIC;
    protected final Map<ProcessingResourceSpecification, Set<IDataStream<MeasuringValue>>> resourceMeasurements = InterpreterUtils.createIdentifierMatchingHashMap();
    protected EvaluationScopeIterator iterator;
    private Map<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>> curElement = InterpreterUtils.createIdentifierMatchingHashMap();

    protected AbstractEvaluationScope() {
        this.iterator = this.iterator();
    }

    public abstract void setResourceMetricsToEvaluate(Map<ProcessingResourceSpecification, Set<MetricDescription>> var1);

    public void reset() {
        this.curElement.clear();
    }

    public final boolean hasNext() {
        return this.iterator.hasNext();
    }

    public final void next() {
        this.curElement = (Map)this.iterator.next();
    }

    public Measure<Double, Duration> getCurrentPointInTime() {
        return this.iterator.getCurrentPointInTime();
    }

    public final Iterator<MeasuringValue> getMeasurementsForProcessingResource(ProcessingResourceSpecification processingResourceSpecification, MetricDescription metric) {
        for (IDataStream<MeasuringValue> stream : this.resourceMeasurements.get(processingResourceSpecification)) {
            if (!InterpreterUtils.isRequiredMetricSatisfiedBy(metric, stream.getMetricDesciption())) continue;
            return stream.iterator();
        }
        return Collections.emptyIterator();
    }

    public final Collection<MeasuringValue> getMeasurements(ProcessingResourceSpecification processingResourceSpecification) {
        Collection<MeasuringValue> result;
        if (this.curElement.containsKey(processingResourceSpecification)) {
            Map<MetricDescription, MeasuringValue> resourceMap = this.curElement.get(processingResourceSpecification);
            result = Collections.unmodifiableCollection(resourceMap.values());
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public EvaluationScopeIterator iterator() {
        return new EvaluationScopeIteratorImpl(this.resourceMeasurements);
    }

    private static class EvaluationScopeIteratorImpl
    implements EvaluationScopeIterator {
        private final Map<ProcessingResourceSpecification, Map<MetricDescription, Iterator<MeasuringValue>>> resourceMeasurementIterators;
        private final Map<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>> nextElement;
        private final Map<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>> currentElement;
        private final PriorityQueue<Measure<Double, Duration>> nextIterationTimingQueue;
        private Measure<Double, Duration> currentPointInTime = Measure.valueOf((double)0.0, (Unit)SI.SECOND);

        private EvaluationScopeIteratorImpl(Map<ProcessingResourceSpecification, Set<IDataStream<MeasuringValue>>> resourceMeasurements) {
            this.resourceMeasurementIterators = InterpreterUtils.createIdentifierMatchingHashMap(resourceMeasurements.size());
            this.currentElement = InterpreterUtils.createIdentifierMatchingHashMap(resourceMeasurements.size());
            this.nextElement = InterpreterUtils.createIdentifierMatchingHashMap(resourceMeasurements.size());
            this.nextIterationTimingQueue = new PriorityQueue();
            for (Map.Entry<ProcessingResourceSpecification, Set<IDataStream<MeasuringValue>>> measurements : resourceMeasurements.entrySet()) {
                Map<MetricDescription, Iterator> resourceIteratorMap = InterpreterUtils.createIdentifierMatchingHashMap(measurements.getValue().size());
                Map<MetricDescription, MeasuringValue> nextElementMap = InterpreterUtils.createIdentifierMatchingHashMap(measurements.getValue().size());
                Map currentElementMap = InterpreterUtils.createIdentifierMatchingHashMap(measurements.getValue().size());
                for (IDataStream<MeasuringValue> stream : measurements.getValue()) {
                    Iterator iterator = stream.iterator();
                    resourceIteratorMap.put(stream.getMetricDesciption(), iterator);
                    if (!iterator.hasNext()) continue;
                    MeasuringValue nextValue = (MeasuringValue)iterator.next();
                    this.nextIterationTimingQueue.add((Measure<Double, Duration>)nextValue.getMeasureForMetric(POINT_IN_TIME_METRIC));
                    nextElementMap.put(stream.getMetricDesciption(), nextValue);
                }
                this.resourceMeasurementIterators.put(measurements.getKey(), resourceIteratorMap);
                this.currentElement.put(measurements.getKey(), currentElementMap);
                this.nextElement.put(measurements.getKey(), nextElementMap);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.nextIterationTimingQueue.isEmpty();
        }

        @Override
        public Map<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available.");
            }
            this.currentPointInTime = this.nextIterationTimingQueue.poll();
            while (this.currentPointInTime.equals(this.nextIterationTimingQueue.peek())) {
                this.nextIterationTimingQueue.poll();
            }
            for (Map.Entry<ProcessingResourceSpecification, Map<MetricDescription, MeasuringValue>> nextResourceEntry : this.nextElement.entrySet()) {
                for (Map.Entry<MetricDescription, MeasuringValue> measurementEntry : nextResourceEntry.getValue().entrySet()) {
                    Iterator<MeasuringValue> nextIterator;
                    if (measurementEntry.getValue().getMeasureForMetric(POINT_IN_TIME_METRIC).compareTo(this.currentPointInTime) > 0) continue;
                    MeasuringValue newValue = this.nextElement.get(nextResourceEntry.getKey()).get(measurementEntry.getKey());
                    if (newValue != null) {
                        this.currentElement.get(nextResourceEntry.getKey()).put(measurementEntry.getKey(), newValue);
                    }
                    if (!(nextIterator = this.resourceMeasurementIterators.get(nextResourceEntry.getKey()).get(measurementEntry.getKey())).hasNext()) continue;
                    MeasuringValue nextValue = nextIterator.next();
                    this.nextElement.get(nextResourceEntry.getKey()).put(measurementEntry.getKey(), nextValue);
                    this.nextIterationTimingQueue.add((Measure<Double, Duration>)nextValue.getMeasureForMetric(POINT_IN_TIME_METRIC));
                }
            }
            return this.currentElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by this iterator");
        }

        @Override
        public Measure<Double, Duration> getCurrentPointInTime() {
            return this.currentPointInTime;
        }
    }
}

