/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.infrastructure.MountedPowerDistributionUnit;
import de.fzi.power.infrastructure.PowerConsumingResourceSet;
import de.fzi.power.infrastructure.PowerDistributionUnit;
import de.fzi.power.infrastructure.PowerInfrastructureRepository;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.infrastructure.util.InfrastructureSwitch;
import de.fzi.power.interpreter.PowerModelRegistry;
import de.fzi.power.interpreter.calculators.CalculatorInstantiator;
import java.util.Objects;

public class PowerModelUpdaterSwitch
extends InfrastructureSwitch<Void> {
    private final CalculatorInstantiator calcInstantiator;
    private final PowerModelRegistry registry;

    public PowerModelUpdaterSwitch(PowerModelRegistry registry, CalculatorInstantiator calcInstantiator) {
        this.registry = Objects.requireNonNull(registry);
        this.calcInstantiator = Objects.requireNonNull(calcInstantiator);
    }

    public Void casePowerInfrastructureRepository(PowerInfrastructureRepository repo) {
        repo.getContainedPowerProvidingEntities().forEach(arg_0 -> ((PowerModelUpdaterSwitch)this).doSwitch(arg_0));
        return null;
    }

    public Void casePowerDistributionUnit(PowerDistributionUnit powerDistributionUnit) {
        this.casePowerProvidingEntity((PowerProvidingEntity)powerDistributionUnit);
        return null;
    }

    public Void casePowerProvidingEntity(PowerProvidingEntity ppe) {
        ppe.getNestedPowerConsumingEntities().forEach(arg_0 -> ((PowerModelUpdaterSwitch)this).doSwitch(arg_0));
        this.registry.updateDistributionPowerModel(ppe, this.calcInstantiator.instantiatePowerProvidingEntityCalculator(ppe));
        return null;
    }

    public Void caseMountedPowerDistributionUnit(MountedPowerDistributionUnit mountedPdu) {
        return this.casePowerDistributionUnit((PowerDistributionUnit)mountedPdu);
    }

    public Void casePowerConsumingResourceSet(PowerConsumingResourceSet powerConsumingResource) {
        this.registry.updateResourcePowerModel(powerConsumingResource, this.calcInstantiator.instantiateResourceCalculator(powerConsumingResource));
        return null;
    }

    public Void caseStatefulPowerConsumingResourceSet(StatefulPowerConsumingResourceSet powerConsumingResource) {
        this.registry.updateStatefulPowerConsumingResource(powerConsumingResource, this.calcInstantiator.instantiateStatefulResourcePowerModelCalculator(powerConsumingResource));
        return null;
    }
}

