/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.measureprovider;

import de.fzi.power.interpreter.measureprovider.ExtendedMeasureProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.metricspec.MetricDescription;

public abstract class AbstractFilterMeasureProvider
extends ExtendedMeasureProvider {
    private final AbstractAdapter adapter;

    public AbstractFilterMeasureProvider(AbstractAdapter adapter) {
        this.adapter = Objects.requireNonNull(adapter, "Filter to use must not be null.");
    }

    protected abstract MetricDescription getTargetMetric();

    protected abstract Map<String, MetricDescription> getAllowedSourceMetrics();

    @Override
    public final Collection<Set<MetricDescription>> getSourceMetrics() {
        return this.getAllowedSourceMetrics().values().stream().map(Collections::singleton).collect(Collectors.toList());
    }

    @Override
    protected final Collection<Set<String>> getSourceMetricIds() {
        return this.getAllowedSourceMetrics().keySet().stream().map(Collections::singleton).collect(Collectors.toList());
    }

    @Override
    public final Set<MetricDescription> getTargetMetrics() {
        return Collections.singleton(this.getTargetMetric());
    }

    @Override
    public IDataSource getDataSource(Set<IDataSource> availableDataSources) {
        for (IDataSource source : availableDataSources) {
            if (!this.adapter.canAccept(source)) continue;
            this.adapter.setDataSource(source);
            return this.adapter;
        }
        return null;
    }

    public Set<String> getKeys() {
        return this.adapter.getKeys();
    }

    public Class<?> getPropertyType(String key) {
        return this.adapter.getPropertyType(key);
    }

    public Map<String, Object> getProperties() {
        return this.adapter.getProperties();
    }

    public void setProperties(Map<String, Object> properties) {
        this.adapter.setProperties(properties);
    }

    public Map<? extends String, ? extends Object> getDefaultConfiguration() {
        return this.adapter.getDefaultConfiguration();
    }

    public boolean isPropertyNotSet(String key) {
        return this.adapter.isPropertyNotSet(key);
    }

    public void unsetProperty(String key) {
        this.adapter.unsetProperty(key);
    }

    public Object getAdapter(Class adapter) {
        return this.adapter.getAdapter(adapter);
    }
}

