/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.ui.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;

public class NestedPropertyConfigurableConfiguration
extends PropertyConfigurable
implements IPropertyListener {
    private Map<String, IPropertyConfigurable> configurables;

    public NestedPropertyConfigurableConfiguration(Set<? extends IPropertyConfigurable> configurables) {
        this.checkAndFillConfigurables(configurables);
    }

    private void checkAndFillConfigurables(Set<? extends IPropertyConfigurable> configurables2) {
        this.configurables = new HashMap<String, IPropertyConfigurable>();
        for (IPropertyConfigurable iPropertyConfigurable : configurables2) {
            for (String key : iPropertyConfigurable.getKeys()) {
                if (this.configurables.containsKey(key)) {
                    throw new IllegalArgumentException("NestedPropertyConfigurableConfiguration does not support nested configurables with duplicate keys");
                }
                this.configurables.put(key, iPropertyConfigurable);
            }
            if (!(iPropertyConfigurable instanceof PropertyConfigurable)) continue;
            ((PropertyConfigurable)iPropertyConfigurable).addObserver((Object)this);
        }
    }

    public Class<?> getPropertyType(String key) {
        IPropertyConfigurable config = this.configurables.get(key);
        return config != null ? config.getPropertyType(key) : null;
    }

    public Map<String, Object> getDefaultConfiguration() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<IPropertyConfigurable> configSet = new HashSet<IPropertyConfigurable>();
        configSet.addAll(this.configurables.values());
        for (IPropertyConfigurable config : configSet) {
            result.putAll(config.getDefaultConfiguration());
        }
        return result;
    }

    public Set<String> getKeys() {
        if (this.configurables == null) {
            return Collections.emptySet();
        }
        return this.configurables.keySet();
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<IPropertyConfigurable> configSet = new HashSet<IPropertyConfigurable>();
        configSet.addAll(this.configurables.values());
        for (IPropertyConfigurable config : configSet) {
            result.putAll(config.getProperties());
        }
        return result;
    }

    public void setProperties(Map<String, Object> properties) {
        HashMap<IPropertyConfigurable, HashMap<String, Object>> splittedProperties = new HashMap<IPropertyConfigurable, HashMap<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            IPropertyConfigurable targetConfigurable = this.configurables.get(entry.getKey());
            if (targetConfigurable == null) {
                throw new IllegalArgumentException("Property identified by \"" + entry.getKey() + "\" does not exist");
            }
            HashMap<String, Object> nestedProperties = (HashMap<String, Object>)splittedProperties.get(targetConfigurable);
            if (nestedProperties == null) {
                nestedProperties = new HashMap<String, Object>();
                splittedProperties.put(targetConfigurable, nestedProperties);
            }
            nestedProperties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : splittedProperties.entrySet()) {
            ((IPropertyConfigurable)entry.getKey()).setProperties((Map)entry.getValue());
        }
        ((IPropertyListener)super.getEventDispatcher()).propertyChangeCompleted();
    }

    public boolean isPropertyNotSet(String key) {
        IPropertyConfigurable config = this.configurables.get(key);
        if (config == null) {
            throw new IllegalArgumentException("Property identified by \"" + key + "\" does not exist");
        }
        return config.isPropertyNotSet(key);
    }

    public void unsetProperty(String key) {
        IPropertyConfigurable config = this.configurables.get(key);
        if (config == null) {
            throw new IllegalArgumentException("Property identified by \"" + key + "\" does not exist");
        }
        config.unsetProperty(key);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        return null;
    }

    public void addObserver(IPropertyListener observer) {
        super.addObserver((Object)observer);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue) {
        ((IPropertyListener)super.getEventDispatcher()).propertyChanged(key, oldValue, newValue);
    }

    public void propertyChangeCompleted() {
    }
}

