/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.ui.views.navigator;

import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.interpreter.calculators.energy.AbstractCumulativeEnergyCalculator;
import de.fzi.power.interpreter.calculators.energy.SimpsonRuleCumulativeEnergyCalculator;
import de.fzi.power.ui.Activator;
import de.fzi.power.ui.adapters.AnalysisCumulativeEnergyConsumptionAdapter;
import de.fzi.power.ui.adapters.AnalysisPowerConsumptionAdapter;
import de.fzi.power.ui.views.configuration.ExtendedMeasureProviderConfigurationContainer;
import de.fzi.power.ui.views.util.Edp2RunSelectionListener;
import de.fzi.power.ui.views.util.PowerInfrastructureEntititySelectionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataSourceListener;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.chaindescription.ChainDescription;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.IVisualisationInput;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class Navigator
extends ViewPart {
    private static final Logger LOGGER = Logger.getLogger(Navigator.class.getCanonicalName());
    private final ISelectionListener listener = new PowerInfrastructureEntititySelectionListener(this);
    private PowerProvidingEntity powerProvidingEntity = null;
    private final ISelectionListener edp2listener = new Edp2RunSelectionListener(this);
    private ExperimentRun run;
    private ExtendedMeasureProviderConfigurationContainer configurationContainer;
    private static final String DATASINK_EXTENSION_POINT_ID = "org.palladiosimulator.edp2.visualization.datasink";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ELEMENT_ID_PROPERTY = "property";
    private static final String PROPERTY_KEY_ATTRIBUTE = "key";
    private static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SCATTER_PLOT_ID = "org.palladiosimulator.edp2.visualization.inputs.ScatterPlotInput";
    private static final String CHART_TITLE = "Power Consumption over Time";
    private static final String CHART_TITLE_ATTRIBUTE = "title";
    private static final String CHART_EDITOR = "org.palladiosimulator.edp2.visualization.editors.JFreeChartEditor";
    private static final String ENERGY_TITLE = "Cumulative Energy Consumption over Time";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.addSelectionListener(this.listener);
        service.addSelectionListener(this.edp2listener);
        this.configurationContainer = new ExtendedMeasureProviderConfigurationContainer();
        this.configurationContainer.createControl(parent);
        this.configurationContainer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.configurationContainer.initializeFrom(new AnalysisPowerConsumptionAdapter().getProperties());
        Button analyzeConsumptionButton = new Button(parent, 8);
        analyzeConsumptionButton.setText("Show power consumption over time");
        analyzeConsumptionButton.setLayoutData((Object)new GridData(0x1000008, 0x1000008, true, false, 1, 1));
        Listener buttonListener = new Listener(){

            public void handleEvent(Event event) {
                if (Navigator.this.powerProvidingEntity == null || Navigator.this.run == null) {
                    if (Navigator.this.powerProvidingEntity == null) {
                        MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No PowerProvidingEntity selected", (String)"Make sure to select a PowerProvidingEntity in one of the EMF-based tree editors, e.g. a MountedPowerDistributionUnit instance.");
                    } else if (Navigator.this.run == null) {
                        MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No ExperimentRun selected", (String)"Make sure to select an ExperimentRun in EDP2's 'Experiment' View.");
                    }
                } else if (!Navigator.this.configurationContainer.isValid()) {
                    MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Configuration Validation Error", (String)Navigator.this.configurationContainer.getErrorMessage());
                } else {
                    AnalysisPowerConsumptionAdapter powerAdapter = Navigator.this.createAndOpenPowerConsumptionChart();
                    if (powerAdapter != null) {
                        Navigator.this.createAndOpenEnergyConsumptionChart(powerAdapter);
                    }
                }
            }

            private Listener init(Navigator navigator) {
                return this;
            }
        }.init(this);
        analyzeConsumptionButton.addListener(13, buttonListener);
    }

    private AnalysisPowerConsumptionAdapter createAndOpenPowerConsumptionChart() {
        IConfigurationElement[] visualizationExtensions;
        AnalysisPowerConsumptionAdapter adapter = null;
        AbstractVisualizationInput configurable = null;
        IConfigurationElement element = null;
        IConfigurationElement[] iConfigurationElementArray = visualizationExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(DATASINK_EXTENSION_POINT_ID);
        int n = visualizationExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getAttribute(ID_ATTRIBUTE).equals(SCATTER_PLOT_ID)) {
                try {
                    configurable = (AbstractVisualizationInput)e.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e1) {
                    LOGGER.log(Level.SEVERE, "Error in creating a Visualization referenced in an extension: Respective Id is " + e.getAttribute(ID_ATTRIBUTE) + ".");
                    LOGGER.log(Level.SEVERE, e1.getMessage());
                    throw new RuntimeException();
                }
                element = e;
                break;
            }
            ++n2;
        }
        if (configurable != null) {
            adapter = new AnalysisPowerConsumptionAdapter();
            adapter.setExperimentRun(this.run);
            adapter.setPowerProvidingEntity(this.powerProvidingEntity);
            Map adapterConfiguration = adapter.getProperties();
            this.configurationContainer.performApply(adapterConfiguration);
            adapter.setProperties(adapterConfiguration);
            Map<String, Object> elementProperties = this.createElementProperties(element, (IPropertyConfigurable)configurable);
            elementProperties.put(CHART_TITLE_ATTRIBUTE, CHART_TITLE);
            elementProperties.put("inputName", CHART_TITLE);
            configurable.setProperties(elementProperties);
            ChainDescription chainDescription = new ChainDescription(element.getAttribute(ID_ATTRIBUTE), element.getAttribute(NAME_ATTRIBUTE), (IDataSource)adapter, (IPropertyConfigurable)configurable);
            this.tryOpenChartEditor(chainDescription, adapter);
        }
        return adapter;
    }

    private void createAndOpenEnergyConsumptionChart(AnalysisPowerConsumptionAdapter powerAdapter) {
        IConfigurationElement[] visualizationExtensions;
        AbstractVisualizationInput configurable = null;
        IConfigurationElement element = null;
        IConfigurationElement[] iConfigurationElementArray = visualizationExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(DATASINK_EXTENSION_POINT_ID);
        int n = visualizationExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getAttribute(ID_ATTRIBUTE).equals(SCATTER_PLOT_ID)) {
                try {
                    configurable = (AbstractVisualizationInput)e.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e1) {
                    LOGGER.log(Level.SEVERE, "Error in creating a Visualization referenced in an extension: Respective Id is " + e.getAttribute(ID_ATTRIBUTE) + ".");
                    LOGGER.log(Level.SEVERE, e1.getMessage());
                    throw new RuntimeException();
                }
                element = e;
                break;
            }
            ++n2;
        }
        if (configurable != null) {
            SimpsonRuleCumulativeEnergyCalculator energyCalculator = new SimpsonRuleCumulativeEnergyCalculator();
            AnalysisCumulativeEnergyConsumptionAdapter energyAdapter = new AnalysisCumulativeEnergyConsumptionAdapter((AbstractCumulativeEnergyCalculator)energyCalculator);
            energyAdapter.setDataSource(new EnergyAdapterDataSource(powerAdapter, (IPropertyConfigurable)configurable));
            Map<String, Object> elementProperties = this.createElementProperties(element, (IPropertyConfigurable)configurable);
            elementProperties.put(CHART_TITLE_ATTRIBUTE, ENERGY_TITLE);
            elementProperties.put("inputName", ENERGY_TITLE);
            configurable.setProperties(elementProperties);
            ChainDescription chainDescription = new ChainDescription(element.getAttribute(ID_ATTRIBUTE), element.getAttribute(NAME_ATTRIBUTE), (IDataSource)energyAdapter, (IPropertyConfigurable)configurable);
            this.tryOpenChartEditor(chainDescription, (AbstractDataSource)energyAdapter);
        }
    }

    private Map<String, Object> createElementProperties(IConfigurationElement element, IPropertyConfigurable configurable) {
        HashMap<String, Object> elementProperties = new HashMap<String, Object>(configurable.getProperties());
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ELEMENT_ID_PROPERTY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement property = iConfigurationElementArray[n2];
            elementProperties.put(property.getAttribute(PROPERTY_KEY_ATTRIBUTE), property.getAttribute(PROPERTY_VALUE_ATTRIBUTE));
            ++n2;
        }
        return elementProperties;
    }

    private void tryOpenChartEditor(ChainDescription chainDescription, AbstractDataSource inputAdapter) {
        assert (chainDescription != null && inputAdapter != null);
        IVisualisationInput chartInput = (IVisualisationInput)chainDescription.getVisualizationInput();
        chartInput.addInput(chartInput.createNewInput((IDataSource)inputAdapter));
        try {
            IWorkbenchPage page = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.openEditor((IEditorInput)chartInput, CHART_EDITOR);
        }
        catch (PartInitException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setFocus() {
    }

    public void setSelectedPowerProvidingEntity(PowerProvidingEntity selectedPowerProvidingEntity) {
        this.powerProvidingEntity = selectedPowerProvidingEntity;
    }

    public void setSelectedExperimentRun(ExperimentRun run) {
        this.run = run;
    }

    private static class EnergyAdapterDataSource
    implements IDataSource {
        private final AnalysisPowerConsumptionAdapter powerAdapter;
        private final IPropertyConfigurable conf;

        public EnergyAdapterDataSource(AnalysisPowerConsumptionAdapter powerAdapter, IPropertyConfigurable conf) {
            this.powerAdapter = powerAdapter;
            this.conf = conf;
        }

        public boolean isCompatibleWith(MetricDescription other) {
            return this.getMetricDesciption().equals(other);
        }

        public MetricDescription getMetricDesciption() {
            return MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE;
        }

        public MeasuringPoint getMeasuringPoint() {
            return this.powerAdapter.getMeasuringPoint();
        }

        public <G extends IPropertyConfigurable> G getConfiguration() {
            IPropertyConfigurable config = this.conf;
            return (G)config;
        }

        public IDataStream<MeasuringValue> getDataStream() {
            return this.powerAdapter.getDataStream();
        }

        public void addObserver(IDataSourceListener observer) {
        }

        public void removeObserver(IDataSourceListener observer) {
        }
    }
}

