/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.ui.adapters;

import de.fzi.power.interpreter.calculators.energy.AbstractCumulativeEnergyCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Energy;
import javax.measure.unit.Unit;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class AnalysisCumulativeEnergyConsumptionAdapter
extends AbstractAdapter
implements IPersistable,
IPersistableElement {
    private static final MetricDescription ADAPTER_INPUT_METRIC = MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE;
    private static final MetricSetDescription ADAPTER_OUTPUT_METRIC = MetricDescriptionConstants.CUMULATIVE_ENERGY_CONSUMPTION_TUPLE;
    private static final Unit<Energy> WATT_HOURS = PowerModelConstants.WATT_HOURS;
    private final AbstractCumulativeEnergyCalculator energyCalculator;

    public AnalysisCumulativeEnergyConsumptionAdapter(AbstractCumulativeEnergyCalculator calculator) {
        super(ADAPTER_INPUT_METRIC);
        this.energyCalculator = Objects.requireNonNull(calculator, "Passed energy calculator must not be null.");
    }

    private static TupleMeasurement createTupleMeasurement(Measure<Double, Duration> pointInTime, Amount<Energy> energySample) {
        return new TupleMeasurement(ADAPTER_OUTPUT_METRIC, new Measure[]{pointInTime, Measure.valueOf((double)energySample.doubleValue(energySample.getUnit()), (Unit)energySample.getUnit())});
    }

    private Collection<MeasuringValue> obtainEnergyMeasurements(IDataStream<MeasuringValue> powerMeasurements) {
        Amount[] powerAmounts = new Amount[powerMeasurements.size()];
        Measure[] pointsInTime = new Measure[powerAmounts.length];
        int index = 0;
        for (MeasuringValue measurement : powerMeasurements) {
            Measure tmp = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POWER_CONSUMPTION);
            powerAmounts[index] = Amount.valueOf((double)tmp.doubleValue(tmp.getUnit()), (Unit)tmp.getUnit());
            pointsInTime[index++] = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        }
        Amount samplingRate = Amount.valueOf((double)pointsInTime[1].doubleValue(pointsInTime[1].getUnit()), (Unit)pointsInTime[1].getUnit()).minus(Amount.valueOf((double)pointsInTime[0].doubleValue(pointsInTime[0].getUnit()), (Unit)pointsInTime[0].getUnit()));
        this.energyCalculator.reset();
        this.energyCalculator.setSamplingPeriod((Measurable)samplingRate);
        this.energyCalculator.setOffset((Measurable)Amount.valueOf((double)((Double)pointsInTime[0].getValue()), (Unit)pointsInTime[0].getUnit()));
        return IntStream.range(0, pointsInTime.length).mapToObj(i -> AnalysisCumulativeEnergyConsumptionAdapter.createTupleMeasurement((Measure<Double, Duration>)pointsInTime[i], (Amount<Energy>)this.energyCalculator.calculateNext((Measurable)powerAmounts[i]).to(WATT_HOURS))).collect(Collectors.toList());
    }

    public boolean canAccept(IDataSource dataSource) {
        if (dataSource == null || dataSource.getDataStream() == null) {
            return false;
        }
        return dataSource.getDataStream().isCompatibleWith(ADAPTER_INPUT_METRIC);
    }

    public IDataStream<MeasuringValue> getDataStream() {
        IDataSource source = this.getDataSource();
        if (source == null) {
            throw new IllegalStateException("No data source set. Adapter cannot be applied.");
        }
        IDataStream stream = source.getDataStream();
        return new OutputDataStream(this.obtainEnergyMeasurements((IDataStream<MeasuringValue>)stream));
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    private static class OutputDataStream
    implements IDataStream<MeasuringValue> {
        private final Collection<MeasuringValue> outputData;

        public OutputDataStream(Collection<MeasuringValue> energyMeasurements) {
            this.outputData = energyMeasurements;
        }

        public boolean isCompatibleWith(MetricDescription other) {
            return this.getMetricDesciption().equals(other);
        }

        public MetricDescription getMetricDesciption() {
            return ADAPTER_OUTPUT_METRIC;
        }

        public Iterator<MeasuringValue> iterator() {
            return this.outputData.iterator();
        }

        public int size() {
            return this.outputData.size();
        }

        public void close() {
        }
    }
}

