/**	
 *  Copyright (c) 2005-2014 VedantaTree all rights reserved.
 * 
 *  This file is part of ExpressionOasis.
 *
 *  ExpressionOasis is free software. You can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  ExpressionOasis is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES 
 *  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 *  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE 
 *  OR OTHER DEALINGS IN THE SOFTWARE.See the GNU Lesser General Public License 
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with ExpressionOasis. If not, see <http://www.gnu.org/licenses/>.
 *  
 *  Please consider to contribute any enhancements to upstream codebase. 
 *  It will help the community in getting improved code and features, and 
 *  may help you to get the later releases with your changes.
 */
package org.vedantatree.expressionoasis.grammar;

/**
 * This class represents the expression token generated by the parser while
 * parsing the string expression. It contains the token string and index in the
 * expression string.
 * 
 * Example:
 * 1+2+pow(3,4)
 * 1, +, 2, +, pow, (, 3, ',', 4, ) are tokens
 * 
 * @author Parmod Kamboj
 * @author Mohit Gupta
 * 
 * @version 1.0
 */
public class ExpressionToken
{

	/**
	 * Value of this token
	 */
	private String	value;

	/**
	 * Index of this token in expression string
	 */
	private int		index;

	/**
	 * Constructs the ExpressionToken
	 * 
	 * @param value
	 * @param index
	 */
	public ExpressionToken( String value, int index )
	{
		this.value = value;
		this.index = index;
	}

	/**
	 * Gets the value of index.
	 * 
	 * @return Returns the index.
	 */
	public int getIndex()
	{
		return index;
	}

	/**
	 * Gets the value of value.
	 * 
	 * @return Returns the value.
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		return "{" + value + ", " + index + "}";
	}
}