/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.Compiler;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionTypeFinder;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.grammar.Grammar;
import org.vedantatree.expressionoasis.types.ValueObject;

public final class ExpressionEngine {
    private static Log LOGGER = LogFactory.getLog(ExpressionEngine.class);
    private static final Compiler compiler = new Compiler();

    private ExpressionEngine() {
    }

    public static Grammar getGrammar() {
        return compiler.getGrammar();
    }

    public static Object evaluate(String expression, ExpressionContext expressionContext) throws ExpressionEngineException {
        Expression compiledExpression = ExpressionEngine.compileExpression(expression, expressionContext, true);
        ValueObject expressionValue = compiledExpression.getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("expressionValue[" + expressionValue.getValue() + "]"));
        }
        return expressionValue.getValue();
    }

    public static Expression compileExpression(String expression, ExpressionContext expressionContext, boolean validate) throws ExpressionEngineException {
        return compiler.compile(expression, expressionContext, validate);
    }

    public static Set<String> getVariableNames(String expression) throws ExpressionEngineException {
        LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
        Expression exp = ExpressionEngine.compileExpression(expression, new ExpressionContext(), false);
        ExpressionTypeFinder finder = new ExpressionTypeFinder(exp, IdentifierExpression.class);
        LinkedHashSet<Expression> foundVariables = finder.getExpressions();
        for (Expression variable : foundVariables) {
            String variableName = ((IdentifierExpression)variable).getIdentifierName();
            variableNames.add(variableName);
        }
        return variableNames;
    }

    public static void main(String[] args) throws ExpressionEngineException {
        String expression = "null != 1.0";
        Object result = ExpressionEngine.evaluate(expression, new ExpressionContext());
        result = ExpressionEngine.evaluate(expression, new ExpressionContext());
        System.out.println("Result[" + result + "]");
    }
}

