/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import java.util.HashMap;
import java.util.Map;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.StringUtils;

public abstract class BinaryOperatorExpression
implements Expression {
    private static final Map TYPE_PAIR_CACHE = new HashMap();
    private static Map typePairMapping = new HashMap();
    protected Expression leftOperandExpression;
    protected Expression rightOperandExpression;

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        Expression[] arguments = null;
        try {
            arguments = (Expression[])parameters;
            if (arguments == null || arguments.length != 2 || arguments[0] == null || arguments[1] == null) {
                throw new ExpressionEngineException("Child expressions information is not valid.");
            }
        }
        catch (ClassCastException ex) {
            throw new ExpressionEngineException("Child expressions information is not valid.");
        }
        this.leftOperandExpression = arguments[0];
        this.rightOperandExpression = arguments[1];
        if (validate) {
            this.validate(expressionContext);
        }
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        HashMap typeMapping = (HashMap)typePairMapping.get(this.getClass());
        Type type = (Type)typeMapping.get(BinaryOperatorExpression.createTypePair(this.leftOperandExpression.getReturnType(), this.rightOperandExpression.getReturnType()));
        if (type == null && (this.getLeftOperandExpression().getReturnType() == Type.ANY_TYPE || this.getRightOperandExpression().getReturnType() == Type.ANY_TYPE)) {
            type = Type.ANY_TYPE;
        }
        return type;
    }

    public Expression getLeftOperandExpression() {
        return this.leftOperandExpression;
    }

    public Expression getRightOperandExpression() {
        return this.rightOperandExpression;
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.leftOperandExpression = null;
        this.rightOperandExpression = null;
    }

    protected static final TypePair createTypePair(Type leftType, Type rightType) {
        String key = String.valueOf(leftType.getTypeName()) + rightType.getTypeName();
        TypePair typePair = (TypePair)TYPE_PAIR_CACHE.get(key);
        if (typePair == null) {
            typePair = new TypePair(leftType, rightType);
            TYPE_PAIR_CACHE.put(key, typePair);
        }
        return typePair;
    }

    protected static final void addTypePair(Class clazz, Type leftType, Type rightType, Type resultType) {
        if (clazz == null || !BinaryOperatorExpression.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("\"" + clazz.getName() + "\" is not a valid binary operator expression class.");
        }
        HashMap<TypePair, Type> typeMapping = (HashMap<TypePair, Type>)typePairMapping.get(clazz);
        if (typeMapping == null) {
            typeMapping = new HashMap<TypePair, Type>();
            typePairMapping.put(clazz, typeMapping);
        }
        typeMapping.put(BinaryOperatorExpression.createTypePair(leftType, rightType), resultType);
    }

    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        if (this.leftOperandExpression.getReturnType() == null) {
            throw new ExpressionEngineException("Return type of left operand expression: [" + this.leftOperandExpression + "] is null.", 100, null);
        }
        if (this.rightOperandExpression.getReturnType() == null) {
            throw new ExpressionEngineException("Return type of right operand expression: [" + this.rightOperandExpression + "] is null.", 100, null);
        }
        if (this.getReturnType() == null) {
            String prefix = StringUtils.getLastToken(this.getClass().getName(), ".");
            prefix = prefix.substring(0, prefix.length() - "Expression".length());
            throw new ExpressionEngineException("Either no type mapping is defined or Operands of types: [\"" + this.leftOperandExpression.getReturnType() + "\", \"" + this.rightOperandExpression.getReturnType() + "\"] are not supported by operator \"" + prefix + "\"", 100, null);
        }
    }

    public String toString() {
        String prefix = StringUtils.getLastToken(this.getClass().getName(), ".");
        prefix = prefix.substring(0, prefix.length());
        return String.valueOf(prefix) + "( " + this.leftOperandExpression + ", " + this.rightOperandExpression + " )";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
        this.leftOperandExpression.accept(visitor);
        this.rightOperandExpression.accept(visitor);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        return null;
    }

    protected static class TypePair {
        private Type leftType;
        private Type rightType;

        public TypePair(Type leftType, Type rightType) {
            this.leftType = leftType;
            this.rightType = rightType;
        }

        public boolean equals(Object arg) {
            boolean result = false;
            if (arg instanceof TypePair) {
                TypePair typePair = (TypePair)arg;
                result = typePair.leftType == this.leftType && typePair.rightType == this.rightType;
            }
            return result;
        }

        public int hashCode() {
            return (String.valueOf(this.leftType.getTypeName()) + this.rightType.getTypeName()).hashCode();
        }
    }
}

