/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class StringExpression
implements Expression {
    private ValueObject stringValue;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        return this.stringValue;
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return Type.STRING;
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        String value = (String)parameters;
        value = value.substring(1, value.length() - 1);
        value = value.replaceAll("[\\\\][']", "'");
        this.stringValue = new ValueObject(value, Type.STRING);
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.stringValue = null;
    }

    public String toString() {
        return this.stringValue == null ? "String value not set" : (String)this.stringValue.getValue();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

