/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class MinExpression
extends BinaryOperatorExpression {
    static {
        MinExpression.addTypePair(MinExpression.class, Type.LONG, Type.LONG, Type.LONG);
        MinExpression.addTypePair(MinExpression.class, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE);
        MinExpression.addTypePair(MinExpression.class, Type.LONG, Type.DOUBLE, Type.DOUBLE);
        MinExpression.addTypePair(MinExpression.class, Type.DOUBLE, Type.LONG, Type.DOUBLE);
        MinExpression.addTypePair(MinExpression.class, Type.OBJECT, Type.OBJECT, Type.OBJECT);
        MinExpression.addTypePair(MinExpression.class, Type.DOUBLE, Type.OBJECT, Type.DOUBLE);
        MinExpression.addTypePair(MinExpression.class, Type.OBJECT, Type.DOUBLE, Type.DOUBLE);
        MinExpression.addTypePair(MinExpression.class, Type.LONG, Type.OBJECT, Type.LONG);
        MinExpression.addTypePair(MinExpression.class, Type.OBJECT, Type.LONG, Type.LONG);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Number result = null;
        Type returnType = this.getReturnType();
        if (leftValue != null && rightValue != null) {
            if (returnType == Type.LONG) {
                result = new Long(Math.min(((Number)leftValue).longValue(), ((Number)rightValue).longValue()));
            } else if (returnType == Type.DOUBLE) {
                result = new Double(Math.min(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue()));
            }
        }
        return new ValueObject(result, returnType);
    }
}

