/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.property;

import java.beans.IntrospectionException;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.expressions.UnaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.BeanUtils;

public class UnaryPropertyExpression
extends UnaryOperatorExpression {
    private static final String JAVA_BEAN = "JAVA_BEAN";
    private Object bean;
    private String propertyName;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        ValueObject returnValue = null;
        try {
            Object propertyValue = BeanUtils.getPropertyValue(this.bean, this.propertyName);
            Class propertyType = BeanUtils.getPropertyType(this.bean.getClass(), this.propertyName);
            returnValue = new ValueObject(propertyValue, Type.createType(propertyType));
        }
        catch (Exception ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
        return returnValue;
    }

    public void setValue(Object value) throws ExpressionEngineException {
        try {
            BeanUtils.setPropertyValue(this.bean, this.propertyName, value);
        }
        catch (Exception ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        this.bean = expressionContext.getContextProperty(JAVA_BEAN);
        this.propertyName = ((IdentifierExpression)parameters).getIdentifierName();
        super.initialize(expressionContext, parameters, validate);
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        Type returnType = null;
        try {
            Class propertyType = BeanUtils.getPropertyType(this.bean.getClass(), this.propertyName);
            returnType = Type.createType(propertyType);
        }
        catch (IntrospectionException ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
        return returnType;
    }

    @Override
    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        if (this.bean == null) {
            throw new ExpressionEngineException("Bean is not found. Set context property [JAVA_BEAN]");
        }
        try {
            Class<?> clazz = this.bean.getClass();
            Class propertyType = BeanUtils.getPropertyType(clazz, this.propertyName);
            if (propertyType == null) {
                throw new ExpressionEngineException("Property [" + this.propertyName + "] does not exist in " + clazz);
            }
        }
        catch (IntrospectionException ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        super.uninitialize(expressionContext);
        this.bean = null;
        this.propertyName = null;
    }
}

