/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.vedantatree.expressionoasis.config.ConfigFactory;
import org.vedantatree.expressionoasis.config.ExpressionOasisConfig;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.DefaultVariableProvider;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.extensions.VariableProvider;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class ExpressionContext {
    private Map<String, VariableProvider> variableProviders = new HashMap<String, VariableProvider>();
    private List<FunctionProvider> functionProviders = new ArrayList<FunctionProvider>();
    private Map<Object, Object> properties = new Hashtable<Object, Object>();

    public ExpressionContext() throws ExpressionEngineException {
        this.registerFunctionProviders();
        DefaultVariableProvider dvp = new DefaultVariableProvider();
        dvp.addVariable("null", new ValueObject(null, Type.OBJECT));
        this.addVariableProvider(dvp);
    }

    private void registerFunctionProviders() throws ExpressionEngineException {
        ExpressionOasisConfig config = ConfigFactory.getConfig();
        List<FunctionProvider> providers = config.getFunctionProviders();
        for (FunctionProvider provider : providers) {
            this.addFunctionProvider(provider);
        }
    }

    public void addVariableProvider(VariableProvider variableProvider, String providerName) {
        this.variableProviders.put(providerName, variableProvider);
    }

    public void addVariableProvider(VariableProvider variableProvider) {
        this.variableProviders.put(String.valueOf(variableProvider.hashCode()), variableProvider);
    }

    public void addFunctionProvider(FunctionProvider functionProvider) throws ExpressionEngineException {
        this.functionProviders.add(functionProvider);
        functionProvider.initialize(this);
    }

    public Collection<FunctionProvider> getFunctionProviders() {
        return Collections.unmodifiableList(this.functionProviders);
    }

    public Collection<VariableProvider> getVariableProviders() {
        return Collections.unmodifiableCollection(this.variableProviders.values());
    }

    public VariableProvider getVariableProvider(String providerName) {
        return this.variableProviders.get(providerName);
    }

    public void setContextProperty(String propertyName, Object propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name can't be null.");
        }
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue);
        }
    }

    public Object getContextProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void clearVariableProviders() {
        this.variableProviders.clear();
    }

    public void reset() {
        this.variableProviders.clear();
        this.functionProviders.clear();
        this.properties.clear();
    }
}

