/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class BooleanExpression
implements Expression {
    private ValueObject booleanValue;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        return this.booleanValue;
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return Type.BOOLEAN;
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object objectInfo, boolean validate) throws ExpressionEngineException {
        this.booleanValue = new ValueObject(objectInfo.equals("true") ? Boolean.TRUE : Boolean.FALSE, Type.BOOLEAN);
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.booleanValue = null;
    }

    public String toString() {
        return this.booleanValue == null ? "null-not-initialized" : "" + this.booleanValue.getValue();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

