/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class MultiplyExpression
extends BinaryOperatorExpression {
    static {
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.LONG, Type.LONG, Type.LONG);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.LONG, Type.DOUBLE, Type.DOUBLE);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.DOUBLE, Type.LONG, Type.DOUBLE);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.OBJECT, Type.OBJECT, Type.OBJECT);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.DOUBLE, Type.OBJECT, Type.DOUBLE);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.OBJECT, Type.DOUBLE, Type.DOUBLE);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.LONG, Type.OBJECT, Type.LONG);
        MultiplyExpression.addTypePair(MultiplyExpression.class, Type.OBJECT, Type.LONG, Type.LONG);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Number result = null;
        Type returnType = this.getReturnType();
        if (leftValue != null && rightValue != null) {
            if (returnType == Type.LONG) {
                result = new Long(((Number)leftValue).longValue() * ((Number)rightValue).longValue());
            } else if (returnType == Type.DOUBLE) {
                result = new Double(((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue());
            }
        }
        return new ValueObject(result, returnType);
    }
}

