/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.property;

import java.beans.IntrospectionException;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.BeanUtils;

public class PropertyExpression
extends BinaryOperatorExpression {
    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        ValueObject value = this.leftOperandExpression.getValue();
        Type type = this.leftOperandExpression.getReturnType();
        ValueObject returnValue = null;
        try {
            Class<?> clazz = Class.forName(type.getTypeName());
            String propertyName = ((IdentifierExpression)this.rightOperandExpression).getIdentifierName();
            Object propertyValue = BeanUtils.getPropertyValue(value.getValue(), propertyName);
            Class propertyType = BeanUtils.getPropertyType(clazz, propertyName);
            returnValue = new ValueObject(propertyValue, Type.createType(propertyType));
        }
        catch (ClassNotFoundException ex) {
            throw new ExpressionEngineException(String.valueOf(type.getTypeName()) + " class is not found.");
        }
        catch (Exception ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
        return returnValue;
    }

    public void setValue(Object value) throws ExpressionEngineException {
        ValueObject valueObject = this.leftOperandExpression.getValue();
        try {
            String propertyName = ((IdentifierExpression)this.rightOperandExpression).getIdentifierName();
            BeanUtils.setPropertyValue(valueObject.getValue(), propertyName, value);
        }
        catch (Exception ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
    }

    @Override
    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        Type type = this.leftOperandExpression.getReturnType();
        if (type == null) {
            throw new ExpressionEngineException("Return type of left operand expression: [" + this.leftOperandExpression + "] is null.");
        }
        try {
            Class<?> clazz = Class.forName(type.getTypeName());
            String propertyName = ((IdentifierExpression)this.rightOperandExpression).getIdentifierName();
            Class propertyType = BeanUtils.getPropertyType(clazz, propertyName);
            if (propertyType == null) {
                throw new ExpressionEngineException("Property [" + propertyName + "] does not exist in " + clazz);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ExpressionEngineException(String.valueOf(type.getTypeName()) + " class is not found.");
        }
        catch (IntrospectionException ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        Type returnType = null;
        Type type = this.leftOperandExpression.getReturnType();
        try {
            Class<?> clazz = Class.forName(type.getTypeName());
            String propertyName = ((IdentifierExpression)this.rightOperandExpression).getIdentifierName();
            Class propertyType = BeanUtils.getPropertyType(clazz, propertyName);
            returnType = Type.createType(propertyType);
        }
        catch (ClassNotFoundException ex) {
            throw new ExpressionEngineException(String.valueOf(type.getTypeName()) + " class is not found.");
        }
        catch (IntrospectionException ex) {
            throw new ExpressionEngineException(ex.getMessage());
        }
        return returnType;
    }
}

