/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.grammar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.config.ConfigFactory;
import org.vedantatree.expressionoasis.grammar.ExpressionToken;
import org.vedantatree.expressionoasis.grammar.Grammar;
import org.vedantatree.expressionoasis.grammar.rules.IProductionRule;
import org.vedantatree.expressionoasis.grammar.rules.ProductionRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXMLGrammar
implements Grammar {
    private static Log LOGGER = LogFactory.getLog(DefaultXMLGrammar.class);
    public final String FILE_PATH;
    public static final String PRODUCTION_RULES = "productionRules";
    private static final String BINARY_OPERATORS = "binaryOperators";
    public static final String UNARY_OPERATORS = "unaryOperators";
    public static final String FUNCTIONS = "functions";
    public static final String DELIMITERS = "delimiters";
    public static final String BRACKETS = "brackets";
    public static final String IGNORE_BLANK = "ignoreBlank";
    public static final String TRUE = "true";
    public static final String NAME = "name";
    public static final String BRACKET = "bracket";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String OPERATOR = "operator";
    public static final String PRECEDENCE = "precedence";
    public static final String DELIMITER = "delimiter";
    public static final String PRODUCTION_RULE = "productionRule";
    public static final String APPROACHABLE_PATTERN = "approchablePattern";
    public static final String ALLOWED_PATTERN = "allowedPattern";
    private Set<IProductionRule> productionRules;
    private Set<String> unaryOperators;
    private Set<String> binaryOperators;
    private Set<String> functions;
    private Set<String> delimiters;
    private String[][] brackets;
    private Map<String, Integer> binaryPrecedences;
    private Map<String, Integer> unaryPrecedences;
    private boolean ignoreBlank;

    public DefaultXMLGrammar() {
        String grammarPath = ConfigFactory.getConfig().getGrammarPath();
        this.FILE_PATH = grammarPath != null && grammarPath.trim().length() > 0 ? grammarPath : "grammar.xml";
        this.configure();
    }

    @Override
    public boolean isDelimiter(ExpressionToken token) {
        return this.isDelimiter(token.getValue());
    }

    @Override
    public boolean isDelimiter(String token) {
        return this.delimiters.contains(token);
    }

    @Override
    public boolean isApproachable(String token) {
        boolean result = false;
        for (IProductionRule productionRule : this.productionRules) {
            if (!productionRule.isApproaching(token)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean isAllowed(String token) {
        boolean result = false;
        for (IProductionRule productionRule : this.productionRules) {
            if (!productionRule.isAllowed(token)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean isIgnoreBlank() {
        return this.ignoreBlank;
    }

    @Override
    public boolean isOperator(ExpressionToken token) {
        return this.isOperator(token.getValue());
    }

    @Override
    public boolean isOperator(String token) {
        return this.isBinaryOperator(token) || this.isUnary(token);
    }

    @Override
    public boolean isBinaryOperator(ExpressionToken token) {
        return this.isBinaryOperator(token.getValue());
    }

    @Override
    public boolean isBinaryOperator(String token) {
        return this.binaryOperators.contains(token);
    }

    @Override
    public void addFunction(String functionName) {
        this.functions.add(functionName);
        this.unaryPrecedences.put(functionName, 13);
    }

    @Override
    public boolean isFunction(ExpressionToken token) {
        return this.isFunction(token.getValue());
    }

    @Override
    public boolean isFunction(String token) {
        return this.functions.contains(token);
    }

    @Override
    public boolean isUnary(ExpressionToken operator) {
        return this.isUnary(operator.getValue());
    }

    @Override
    public boolean isUnary(String operator) {
        return this.unaryOperators.contains(operator) || this.isFunction(operator);
    }

    @Override
    public boolean isLeftBracket(ExpressionToken token) {
        return this.isLeftBracket(token.getValue());
    }

    @Override
    public boolean isLeftBracket(String token) {
        boolean result = false;
        int length = this.brackets == null ? 0 : this.brackets.length;
        int i = 0;
        while (i < length) {
            result = token.equals(this.brackets[i][0]);
            if (result) break;
            ++i;
        }
        return result;
    }

    @Override
    public boolean isRightBracket(ExpressionToken token) {
        return this.isRightBracket(token.getValue());
    }

    @Override
    public boolean isRightBracket(String token) {
        boolean result = false;
        int length = this.brackets == null ? 0 : this.brackets.length;
        int i = 0;
        while (i < length) {
            result = token.equals(this.brackets[i][1]);
            if (result) break;
            ++i;
        }
        return result;
    }

    @Override
    public boolean isBracket(ExpressionToken token) {
        return this.isBracket(token.getValue());
    }

    @Override
    public boolean isBracket(String token) {
        return this.isRightBracket(token) || this.isLeftBracket(token);
    }

    @Override
    public String getOppositeBracket(String bracket) {
        String result = null;
        int length = this.brackets == null ? 0 : this.brackets.length;
        int i = 0;
        while (i < length) {
            int index = this.search(this.brackets[i], bracket);
            if (index != -1) {
                result = index == 1 ? this.brackets[i][0] : this.brackets[i][1];
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getPrecedenceOrder(ExpressionToken operator, boolean isUnary) {
        return this.getPrecedenceOrder(operator.getValue(), isUnary);
    }

    @Override
    public int getPrecedenceOrder(String operator, boolean isUnary) {
        return isUnary ? this.unaryPrecedences.get(operator).intValue() : this.binaryPrecedences.get(operator).intValue();
    }

    private void configure() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            LOGGER.debug((Object)("resourcePath[" + this.getClass().getClassLoader().getResource("")));
            Document document = builder.parse(this.getClass().getClassLoader().getResourceAsStream(this.FILE_PATH));
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int length = nodeList.getLength();
            int i = 0;
            while (i < length) {
                Node childNode = nodeList.item(i);
                String nodeName = childNode.getNodeName();
                if (childNode.getNodeType() == 1) {
                    if (PRODUCTION_RULES.equals(nodeName)) {
                        this.buildProductionRules((Element)childNode);
                    } else if (BINARY_OPERATORS.equals(nodeName)) {
                        this.buildBinaryOperators((Element)childNode);
                        this.loadBinaryPrecedence((Element)childNode);
                    } else if (UNARY_OPERATORS.equals(nodeName)) {
                        this.buildUnaryOperators((Element)childNode);
                        this.loadUnaryPrecedence((Element)childNode);
                    } else if (FUNCTIONS.equals(nodeName)) {
                        this.buildFunctions((Element)childNode);
                        this.loadFunctionPrecedence((Element)childNode);
                    } else if (DELIMITERS.equals(nodeName)) {
                        this.buildDelimiters((Element)childNode);
                    } else if (BRACKETS.equals(nodeName)) {
                        this.loadBrackets((Element)childNode);
                    } else if (IGNORE_BLANK.equals(nodeName)) {
                        this.ignoreBlank = TRUE.equals(((Element)childNode).getAttribute(NAME));
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while loading the configurations.", ex);
        }
    }

    private void loadBrackets(Element childNode) {
        NodeList childList = childNode.getElementsByTagName(BRACKET);
        int childLength = childList.getLength();
        this.brackets = new String[childLength][2];
        int j = 0;
        while (j < childLength) {
            Element subChildNode = (Element)childList.item(j);
            this.brackets[j][0] = subChildNode.getAttribute(LEFT);
            this.brackets[j][1] = subChildNode.getAttribute(RIGHT);
            ++j;
        }
    }

    private void loadBinaryPrecedence(Element childNode) {
        if (this.binaryPrecedences == null) {
            this.binaryPrecedences = new HashMap<String, Integer>();
        }
        this.loadPrecedence(childNode, this.binaryPrecedences);
    }

    private void loadUnaryPrecedence(Element childNode) {
        if (this.unaryPrecedences == null) {
            this.unaryPrecedences = new HashMap<String, Integer>();
        }
        this.loadPrecedence(childNode, this.unaryPrecedences);
    }

    private void loadFunctionPrecedence(Element childNode) {
        if (this.unaryPrecedences == null) {
            this.unaryPrecedences = new HashMap<String, Integer>();
        }
        this.loadPrecedence(childNode, this.unaryPrecedences);
    }

    private void loadPrecedence(Element childNode, Map<String, Integer> precedences) {
        NodeList childList = childNode.getElementsByTagName(OPERATOR);
        int childLength = childList.getLength();
        int j = 0;
        while (j < childLength) {
            Element subChildNode = (Element)childList.item(j);
            String operator = subChildNode.getAttribute(NAME);
            String precedence = subChildNode.getAttribute(PRECEDENCE);
            precedences.put(operator, new Integer(Integer.parseInt(precedence)));
            ++j;
        }
    }

    private void buildDelimiters(Element childNode) {
        this.delimiters = this.buildSetByAttribute(childNode, DELIMITER, NAME);
    }

    private void buildBinaryOperators(Element childNode) {
        this.binaryOperators = this.buildSetByAttribute(childNode, OPERATOR, NAME);
    }

    private void buildUnaryOperators(Element childNode) {
        this.unaryOperators = this.buildSetByAttribute(childNode, OPERATOR, NAME);
    }

    private void buildFunctions(Element childNode) {
        this.functions = this.buildSetByAttribute(childNode, OPERATOR, NAME);
    }

    private void buildProductionRules(Element childNode) {
        NodeList childList = childNode.getElementsByTagName(PRODUCTION_RULE);
        int childLength = childList.getLength();
        this.productionRules = new HashSet<IProductionRule>(childLength);
        int j = 0;
        while (j < childLength) {
            Element subChildNode = (Element)childList.item(j);
            ProductionRule rule = new ProductionRule(subChildNode.getAttribute(NAME), subChildNode.getAttribute(APPROACHABLE_PATTERN), subChildNode.getAttribute(ALLOWED_PATTERN));
            this.productionRules.add(rule);
            ++j;
        }
    }

    private Set<String> buildSetByAttribute(Element childNode, String tag, String attribute) {
        NodeList childList = childNode.getElementsByTagName(tag);
        int childLength = childList.getLength();
        HashSet<String> set = new HashSet<String>(childLength);
        int j = 0;
        while (j < childLength) {
            Element subChildNode = (Element)childList.item(j);
            set.add(subChildNode.getAttribute(attribute));
            ++j;
        }
        return set;
    }

    private int search(String[] array, String element) {
        int index = -1;
        int length = array == null ? 0 : array.length;
        int i = 0;
        while (i < length) {
            if (element == null) {
                if (array[i] == null) {
                    index = i;
                    break;
                }
            } else if (element.equals(array[i])) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static void main(String[] args) {
        DefaultXMLGrammar grammar = new DefaultXMLGrammar();
        grammar.isOperator("+");
    }
}

