/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.exceptions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.exceptions.ErrorCodes;

public class ExpressionEngineException
extends Exception {
    private static Log LOGGER = LogFactory.getLog(ExpressionEngineException.class);
    private static final long serialVersionUID = 2006122401L;
    protected static final String CUSTOMIZED_ERROR_CODE = "Customized Error Code";
    private int errorCode = Integer.MIN_VALUE;

    public ExpressionEngineException(String msg) {
        this(msg, -1, null);
    }

    public ExpressionEngineException(String msg, Throwable e) {
        this(msg, -1, e);
    }

    public ExpressionEngineException(String msg, int errorCode, Throwable e) {
        this(msg, errorCode, null, false);
    }

    public ExpressionEngineException(String message, int errorCode, Throwable cause, boolean debug) {
        super(message, null);
        this.errorCode = errorCode;
        if (debug) {
            LOGGER.debug((Object)this.getMessage(), cause);
        } else {
            LOGGER.error((Object)this.getMessage(), cause);
        }
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return String.valueOf(super.getMessage()) + ": error-code[" + this.errorCode + "] code-description[" + this.getErrorDescription() + "]";
    }

    protected String getErrorDescription() {
        return this.errorCode >= ErrorCodes.ERROR_DESCRIPTION.length || this.errorCode < 0 ? CUSTOMIZED_ERROR_CODE : ErrorCodes.ERROR_DESCRIPTION[this.errorCode];
    }
}

