/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.extensions.VariableProvider;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.StringUtils;

public class IdentifierExpression
implements Expression {
    private String identifierName;
    private VariableProvider variableProvider;

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return this.variableProvider == null ? null : this.variableProvider.getVariableType(this.getIdentifierName());
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        if (this.variableProvider == null) {
            throw new ExpressionEngineException("Variable Provider does not exist: [" + this.getIdentifierName() + "]");
        }
        return this.variableProvider.getVariableValue(this.getIdentifierName());
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        this.identifierName = (String)parameters;
        if (!StringUtils.isQualifiedString(this.identifierName)) {
            throw new ExpressionEngineException("Identifier name is not valid");
        }
        for (VariableProvider variableProvider : expressionContext.getVariableProviders()) {
            if (!variableProvider.supportsVariable(this.getIdentifierName())) continue;
            this.variableProvider = variableProvider;
            break;
        }
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.identifierName = null;
    }

    public String toString() {
        return "IdentifierExpression:[" + this.getIdentifierName() + "]";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

