/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import java.lang.reflect.Array;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.StringUtils;

public class ArrayIndexExpression
extends BinaryOperatorExpression {
    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object value = this.leftOperandExpression.getValue().getValue();
        long index = ((Number)this.rightOperandExpression.getValue().getValue()).longValue();
        return new ValueObject(Array.get(value, (int)index), this.getReturnType());
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return this.leftOperandExpression.getReturnType().getComponentType();
    }

    @Override
    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        if (!this.leftOperandExpression.getReturnType().isArray() || this.rightOperandExpression.getReturnType() != Type.LONG) {
            String prefix = StringUtils.getLastToken(this.getClass().getName(), ".");
            prefix = prefix.substring(0, prefix.length() - "Expression".length());
            throw new ExpressionEngineException("Operands of types: [\"" + this.leftOperandExpression.getReturnType() + "\", \"" + this.rightOperandExpression.getReturnType() + "\"] are not supported by operator \"" + prefix + "\"");
        }
    }
}

