/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.bitwise;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class BWXorExpression
extends BinaryOperatorExpression {
    static {
        BWXorExpression.addTypePair(BWXorExpression.class, Type.INTEGER, Type.INTEGER, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.LONG, Type.LONG, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.INTEGER, Type.LONG, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.LONG, Type.INTEGER, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.BOOLEAN, Type.BOOLEAN, Type.BOOLEAN);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.OBJECT, Type.OBJECT, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.INTEGER, Type.OBJECT, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.OBJECT, Type.INTEGER, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.LONG, Type.OBJECT, Type.LONG);
        BWXorExpression.addTypePair(BWXorExpression.class, Type.OBJECT, Type.LONG, Type.LONG);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Comparable<Boolean> result = null;
        Type returnType = this.getReturnType();
        if (leftValue != null && rightValue != null) {
            if (returnType == Type.BOOLEAN) {
                result = new Boolean((Boolean)leftValue ^ (Boolean)rightValue);
            } else {
                long leftLongValue = ((Number)leftValue).longValue();
                long rightLongValue = ((Number)rightValue).longValue();
                result = leftLongValue ^ rightLongValue;
            }
        }
        return new ValueObject(result, returnType);
    }
}

