/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.booleanexp;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.booleanexp.ConditionTernaryExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class ResultTernaryExpression
extends BinaryOperatorExpression {
    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return this.getRightOperandExpression().getReturnType();
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        BinaryOperatorExpression leftBinaryExp = (BinaryOperatorExpression)this.leftOperandExpression;
        Object leftValue = leftBinaryExp.getLeftOperandExpression().getValue().getValue();
        return (Boolean)leftValue != false ? leftBinaryExp.getRightOperandExpression().getValue() : this.getRightOperandExpression().getValue();
    }

    @Override
    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        if (this.leftOperandExpression.getReturnType() == null) {
            throw new ExpressionEngineException("Return type of left operand expression: [" + this.leftOperandExpression + "] is null.");
        }
        if (this.rightOperandExpression.getReturnType() == null) {
            throw new ExpressionEngineException("Return type of right operand expression: [" + this.rightOperandExpression + "] is null.");
        }
        if (!(this.getLeftOperandExpression() instanceof ConditionTernaryExpression)) {
            throw new ExpressionEngineException("Left operand is not of ConditionTernary type. LeftOperand: [" + this.leftOperandExpression + "]");
        }
    }
}

