/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.extensions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.ExpressionEngine;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.ExpressionFactory;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.grammar.Grammar;
import org.vedantatree.expressionoasis.types.MethodKey;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class DefaultFunctionProvider
implements FunctionProvider {
    private static Log LOGGER = LogFactory.getLog(DefaultFunctionProvider.class);
    private Class functionProviderClass;
    private Object functionProviderObject;
    private Map<MethodKey, Method> methodMap = new HashMap<MethodKey, Method>();
    private boolean initialized;

    public DefaultFunctionProvider(Class functionProviderClass) throws ExpressionEngineException {
        if (functionProviderClass == null) {
            throw new IllegalArgumentException("Class of function provider can't be null.");
        }
        this.functionProviderClass = functionProviderClass;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Creating function provider for class " + functionProviderClass.getName()));
        }
        this.registerFunctions();
    }

    private void registerFunctions() {
        ExpressionFactory factory = ExpressionFactory.getInstance();
        Grammar grammar = ExpressionEngine.getGrammar();
        Method[] methods = this.functionProviderClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            String functionName = methods[i].getName();
            factory.addFunction(functionName);
            grammar.addFunction(functionName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Registered function " + functionName));
            }
            ++i;
        }
    }

    @Override
    public Type getFunctionType(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        if (!this.isInitialized()) {
            throw new ExpressionEngineException("Function provider is not initialized by now.");
        }
        Method method = this.getMethod(functionName, parameterTypes);
        Type type = null;
        if (method != null) {
            type = Type.createType(method.getReturnType());
        }
        return type;
    }

    @Override
    public ValueObject getFunctionValue(String functionName, ValueObject[] parameters) throws ExpressionEngineException {
        if (!this.isInitialized()) {
            throw new ExpressionEngineException("Function provider is not initialized by now.");
        }
        Method method = this.getMethod(functionName, parameters);
        ValueObject value = null;
        if (method != null) {
            try {
                int length = parameters == null ? 0 : parameters.length;
                Object[] params = new Object[length];
                int i = 0;
                while (i < params.length) {
                    params[i] = parameters[i].getValue();
                    ++i;
                }
                Object result = method.invoke(this.functionProviderObject, params);
                value = new ValueObject(result, Type.createType(method.getReturnType()));
            }
            catch (Exception ex) {
                throw new ExpressionEngineException("Error occured while executing method.", ex);
            }
        }
        return value;
    }

    @Override
    public boolean supportsFunction(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        return this.getMethod(functionName, parameterTypes) != null;
    }

    @Override
    public void initialize(ExpressionContext expressionContext) throws ExpressionEngineException {
        if (expressionContext == null) {
            throw new IllegalArgumentException("Expression Context can't be null.");
        }
        if (this.functionProviderObject == null) {
            try {
                Constructor constructor = this.functionProviderClass.getConstructor(ExpressionContext.class);
                if (constructor == null) {
                    throw new ExpressionEngineException("Function provider class does not required constructor with ExpressionContext as parameter. FunctionProviderClass[" + this.functionProviderClass + "]");
                }
                this.functionProviderObject = constructor.newInstance(expressionContext);
            }
            catch (ExpressionEngineException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExpressionEngineException("Exception while creating Function Provider. FunctionProviderClass[" + this.functionProviderClass + "]", e);
            }
            Method[] methods = this.functionProviderClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                MethodKey key = this.createMethodKey(methods[i]);
                this.methodMap.put(key, methods[i]);
                ++i;
            }
        }
        this.setInitialized(true);
    }

    private MethodKey createMethodKey(Method method) {
        Class<?>[] arguments = method.getParameterTypes();
        int length = arguments == null ? 0 : arguments.length;
        Type[] parameterTypes = new Type[length];
        int j = 0;
        while (j < length) {
            try {
                parameterTypes[j] = Type.createType(arguments[j]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating method key: " + e.getMessage(), e);
            }
            ++j;
        }
        MethodKey key = new MethodKey(method.getName(), parameterTypes);
        return key;
    }

    private Method getMethod(String functionName, Type[] parameterTypes) {
        MethodKey thatKey = new MethodKey(functionName, parameterTypes);
        Method method = this.methodMap.get(thatKey);
        if (method == null) {
            Set<Map.Entry<MethodKey, Method>> entrySet = this.methodMap.entrySet();
            for (Map.Entry<MethodKey, Method> entry : entrySet) {
                MethodKey key = entry.getKey();
                if (!thatKey.isAssignaleFrom(key)) continue;
                method = entry.getValue();
                break;
            }
        }
        return method;
    }

    private Method getMethod(String functionName, ValueObject[] parameters) {
        int length = parameters == null ? 0 : parameters.length;
        Type[] parameteTypes = new Type[length];
        int i = 0;
        while (i < length) {
            parameteTypes[i] = parameters[i].getValueType();
            ++i;
        }
        return this.getMethod(functionName, parameteTypes);
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

