/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.grammar.rules;

import java.util.regex.Pattern;
import org.vedantatree.expressionoasis.grammar.rules.IProductionRule;
import org.vedantatree.expressionoasis.utils.StringUtils;

public class ProductionRule
implements IProductionRule {
    private String name;
    private Pattern approachableRegexPattern;
    private Pattern allowedRegexPattern;

    public ProductionRule(String name, String regularExpression) {
        this(name, regularExpression, regularExpression);
    }

    public ProductionRule(String name, String approachableRegex, String allowedRegex) {
        if (!StringUtils.isQualifiedString(approachableRegex) || !StringUtils.isQualifiedString(allowedRegex)) {
            throw new IllegalArgumentException("Passed regular expression can't be null.");
        }
        this.name = name;
        this.allowedRegexPattern = Pattern.compile(allowedRegex);
        this.approachableRegexPattern = Pattern.compile(approachableRegex);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApproaching(String pattern) {
        boolean approaching = this.approachableRegexPattern.matcher(pattern).matches();
        return approaching;
    }

    @Override
    public boolean isAllowed(String token) {
        boolean allowed = this.allowedRegexPattern.matcher(token).matches();
        return allowed;
    }
}

