/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.types;

import org.vedantatree.expressionoasis.types.Type;

public class MethodKey {
    private String methodName;
    private Type[] parameterTypes;
    private String key;

    public MethodKey(String methodName, Type[] parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.key = MethodKey.generateKey(methodName, parameterTypes);
    }

    public static String generateKey(String methodName, Type[] parameterTypes) {
        if (methodName == null) {
            throw new IllegalArgumentException("Passed methodName can't be null.");
        }
        StringBuffer buffer = new StringBuffer(methodName);
        buffer.append('(');
        int length = parameterTypes != null ? parameterTypes.length : 0;
        int i = 0;
        while (i < length) {
            Type type = parameterTypes[i];
            buffer.append(type.getTypeName());
            if (i < length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isAssignaleFrom(MethodKey key) {
        boolean result = false;
        if (key != null && key.methodName.equals(this.methodName)) {
            int length;
            Type[] thatParameterTypes = key.parameterTypes;
            int thatLength = thatParameterTypes != null ? thatParameterTypes.length : 0;
            int n = length = this.parameterTypes != null ? this.parameterTypes.length : 0;
            if (thatLength == length) {
                boolean assignableFrom = true;
                int i = 0;
                while (i < length) {
                    if (!this.parameterTypes[i].isAssignableFrom(thatParameterTypes[i])) {
                        assignableFrom = false;
                        break;
                    }
                    ++i;
                }
                result = assignableFrom;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof MethodKey) {
            MethodKey thatKey = (MethodKey)obj;
            result = thatKey.key.equals(this.key);
        }
        return result;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }
}

