/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.types;

import java.util.HashMap;
import java.util.Map;
import org.vedantatree.expressionoasis.utils.JavaUtils;
import org.vedantatree.expressionoasis.utils.StringUtils;
import org.vedantatree.expressionoasis.utils.Utilities;

public class Type {
    private static final Map<String, Type> TYPE_CACHE = new HashMap<String, Type>();
    public static final Type BYTE = new Type(1, Byte.class);
    public static final Type SHORT = new Type(2, Short.class);
    public static final Type INTEGER = new Type(3, Integer.class);
    public static final Type LONG = new Type(4, Long.class);
    public static final Type DOUBLE = new Type(5, Double.class);
    public static final Type FLOAT = new Type(6, Float.class);
    public static final Type BOOLEAN = new Type(7, Boolean.class);
    public static final Type CHARACTER = new Type(8, Character.class);
    public static final Type STRING = new Type(9, String.class);
    public static final Type XML = new Type(10, null, "Type.XML");
    public static final Type OBJECT = new Type(11, Object.class);
    public static final Type ANY_TYPE = new Type(127, null, "Type.ANY");
    private static final byte CUSTOM_TYPE = -128;
    private String typeName;
    private Class typeClass;
    private byte typeCode;
    private Type componentType;

    static {
        Type.populatePrimitiveTypes();
    }

    private static void populatePrimitiveTypes() {
        new Type(1, Byte.TYPE);
        new Type(2, Short.TYPE);
        new Type(3, Integer.TYPE);
        new Type(4, Long.TYPE);
        new Type(5, Double.TYPE);
        new Type(6, Float.TYPE);
        new Type(7, Boolean.TYPE);
        new Type(8, Character.TYPE);
    }

    private Type(byte typeCode, Class typeClass) {
        this(typeCode, typeClass, null);
    }

    private Type(byte pTypeCode, Class pTypeClass, String pTypeName) {
        if (pTypeClass != null && pTypeName == null) {
            pTypeName = pTypeClass.getName();
        }
        if (!StringUtils.isQualifiedString(pTypeName)) {
            throw new IllegalArgumentException("Type name is not valid. typeCode[" + pTypeCode + "] typeName[" + pTypeName + "] typeClass[" + pTypeClass + "]");
        }
        if (TYPE_CACHE.containsKey(pTypeName)) {
            throw new IllegalArgumentException("A type is already created for given type code. given-code[" + pTypeCode + "] given-typeName[" + pTypeName + "] existing-type[" + TYPE_CACHE.get(pTypeName) + "]");
        }
        this.typeCode = pTypeCode;
        this.typeName = pTypeName;
        if (pTypeClass == null) {
            try {
                pTypeClass = Class.forName(pTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.typeClass = pTypeClass;
        TYPE_CACHE.put(pTypeName, this);
    }

    public static final Type createType(Class<?> typeClass) {
        Utilities.assertNotNullArgument(typeClass, "Type-Class");
        return Type.createTypeInternal(typeClass, typeClass.getName());
    }

    public static final Type createType(String typeName) {
        return Type.createTypeInternal(null, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Type createTypeInternal(Class typeClass, String typeName) {
        StringUtils.assertQualifiedArgument(typeName, "typeName");
        Type type = TYPE_CACHE.get(typeName);
        if (type == null) {
            Map<String, Type> map = TYPE_CACHE;
            synchronized (map) {
                type = TYPE_CACHE.get(typeName);
                if (type == null) {
                    type = new Type(-128, typeClass, typeName);
                    TYPE_CACHE.put(typeName, type);
                }
            }
        }
        return type;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final Type getComponentType() {
        if (this.componentType != null || this.typeClass == null) {
            return this.componentType;
        }
        Class<?> clazz = this.typeClass.getComponentType();
        this.componentType = clazz != null ? Type.createType(clazz) : null;
        return this.componentType;
    }

    public final boolean isAssignableFrom(Type type) {
        boolean result = false;
        if (type != null && type.getTypeClass() != null && this.typeClass != null) {
            Class thisClass = this.typeClass;
            Class<?> thatClass = type.getTypeClass();
            result = thatClass.isAssignableFrom(thisClass);
        }
        return result;
    }

    public final Class<?> getTypeClass() {
        return this.typeClass;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public boolean equals(Object arg) {
        boolean result = false;
        if (arg instanceof Type) {
            Type type = (Type)arg;
            boolean bl = result = type.typeCode == this.typeCode;
            if (result && !(result = type.typeName.equals(this.typeName))) {
                if (this.getTypeClass() != null && this.getTypeClass().isPrimitive()) {
                    String newTypeClass = JavaUtils.convertToWrapper(this.getTypeClass()).getName();
                    result = type.typeName.equals(newTypeClass);
                } else if (type.getTypeClass() != null && type.getTypeClass().isPrimitive()) {
                    String newTypeClass = JavaUtils.convertToWrapper(type.getTypeClass()).getName();
                    result = this.typeName.equals(newTypeClass);
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.getTypeName();
    }

    public String toDebugString() {
        return "Type: type[" + this.typeCode + "] typeName[" + this.typeName + "] typeClass[" + this.typeClass + "]";
    }

    public static void main(String[] args) throws Exception {
        System.out.println(INTEGER);
        System.out.println(BYTE);
        System.out.println(DOUBLE);
        System.out.println(LONG);
        System.out.println(CHARACTER);
        System.out.println(OBJECT);
        System.out.println(ANY_TYPE);
        System.out.println(STRING);
        System.out.println(Boolean.TYPE);
        System.out.println(Boolean.TYPE.getName());
        Type booleanArrayType = Type.createType(new Boolean[2].getClass());
        System.out.println("boolean array type[" + booleanArrayType.toDebugString() + "]");
        Type componentType = booleanArrayType.getComponentType();
        System.out.println("boolean array type's component type[" + componentType.toDebugString() + "]");
    }
}

