/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.vedantatree.expressionoasis.ui.ExpressionEvaluator;
import org.vedantatree.expressionoasis.ui.IExpressionEvaluator;

public class ExpressionEvaluatorUI
implements ActionListener,
IExpressionEvaluator {
    private ExpressionEvaluator calc = null;
    private JFrame calcFrame = new JFrame("Expression Evaluator");
    private JPanel[] rows = new JPanel[9];
    private JTextField expressionText = new JTextField();
    private JLabel expressionLabel = new JLabel("Expression :");
    private JTextField result = new JTextField();
    private JLabel resultLabel = new JLabel("Expression Result :");
    private JButton[] numericKeys = new JButton[10];
    private JButton addKey = new JButton("    +    ");
    private JButton minusKey = new JButton("    -    ");
    private JButton multiplyKey = new JButton("    *    ");
    private JButton divideKey = new JButton("    /    ");
    private JButton equalsKey = new JButton("             =              ");
    private JButton resetKey = new JButton("    C    ");
    private JButton fractionKey = new JButton("    .    ");
    private JButton absKey = new JButton(" abs ");
    private JButton sinKey = new JButton("  sin   ");
    private JButton cosKey = new JButton(" cos ");
    private JButton tanKey = new JButton("  tan ");
    private JButton asinKey = new JButton("  asin ");
    private JButton acosKey = new JButton("  acos ");
    private JButton atanKey = new JButton(" atan   ");
    private JButton atan2Key = new JButton("atan2");
    private JButton expKey = new JButton(" exp ");
    private JButton logKey = new JButton("  log   ");
    private JButton sqrtKey = new JButton(" sqrt ");
    private JButton ceilKey = new JButton("  ceil  ");
    private JButton floorKey = new JButton("  floor  ");
    private JButton rintKey = new JButton("  rint   ");
    private JButton roundKey = new JButton(" round ");
    private JButton randomKey = new JButton("random");
    private JButton leftShiftKey = new JButton("  << ");
    private JButton rightShiftKey = new JButton("  >> ");
    private JButton unRightShiftKey = new JButton("  >>> ");
    private JButton bitORKey = new JButton("     |      ");
    private JButton bitANDKey = new JButton("    &     ");
    private JButton bitComplementKey = new JButton("     ~     ");
    private JButton greaterEqKey = new JButton("     >=      ");
    private JButton greaterKey = new JButton("   >  ");
    private JButton lessEqKey = new JButton("  <=  ");
    private JButton lessKey = new JButton("    <   ");
    private JButton notEqKey = new JButton("    !=    ");
    private JButton equalsToKey = new JButton("    ==    ");
    private JButton leftBraceKey = new JButton("    (    ");
    private JButton rightBraceKey = new JButton("    )    ");

    public void drawCalculator() {
        this.calc = new ExpressionEvaluator();
        this.calcFrame.setDefaultCloseOperation(3);
        JPanel calculatorPane = (JPanel)this.calcFrame.getContentPane();
        int i = 0;
        while (i < this.rows.length) {
            this.rows[i] = new JPanel();
            ++i;
        }
        i = 0;
        while (i < this.numericKeys.length) {
            this.numericKeys[i] = new JButton("     " + i + "     ");
            this.numericKeys[i].setActionCommand(String.valueOf(i));
            this.numericKeys[i].addActionListener(this);
            ++i;
        }
        this.result.setColumns(20);
        this.result.setText("");
        this.result.setHorizontalAlignment(4);
        this.result.setEditable(false);
        this.resultLabel.setHorizontalAlignment(4);
        this.rows[0].add(this.resultLabel);
        this.rows[0].add(this.result);
        this.expressionText.setColumns(20);
        this.expressionText.setText("");
        this.expressionText.setHorizontalAlignment(4);
        this.expressionLabel.setHorizontalAlignment(4);
        this.rows[1].add(this.expressionLabel);
        this.rows[1].add(this.expressionText);
        this.rows[2].setLayout(new FlowLayout(0));
        this.rows[2].add(this.numericKeys[7]);
        this.rows[2].add(this.numericKeys[8]);
        this.rows[2].add(this.numericKeys[9]);
        this.rows[2].add(this.divideKey);
        this.rows[2].add(this.multiplyKey);
        this.rows[2].add(this.minusKey);
        this.rows[2].add(this.resetKey);
        this.divideKey.setActionCommand("/");
        this.divideKey.addActionListener(this);
        this.multiplyKey.setActionCommand("*");
        this.multiplyKey.addActionListener(this);
        this.minusKey.setActionCommand("-");
        this.minusKey.addActionListener(this);
        this.resetKey.setActionCommand("reset");
        this.resetKey.addActionListener(this);
        this.rows[3].setLayout(new FlowLayout(0));
        this.rows[3].add(this.numericKeys[4]);
        this.rows[3].add(this.numericKeys[5]);
        this.rows[3].add(this.numericKeys[6]);
        this.rows[3].add(this.addKey);
        this.rows[3].add(this.fractionKey);
        this.rows[3].add(this.absKey);
        this.rows[3].add(this.logKey);
        this.addKey.setActionCommand("+");
        this.addKey.addActionListener(this);
        this.fractionKey.setActionCommand(".");
        this.fractionKey.addActionListener(this);
        this.absKey.setActionCommand("abs");
        this.absKey.addActionListener(this);
        this.logKey.setActionCommand("log");
        this.logKey.addActionListener(this);
        this.rows[4].setLayout(new FlowLayout(0));
        this.rows[4].add(this.numericKeys[1]);
        this.rows[4].add(this.numericKeys[2]);
        this.rows[4].add(this.numericKeys[3]);
        this.rows[4].add(this.sinKey);
        this.rows[4].add(this.cosKey);
        this.rows[4].add(this.tanKey);
        this.rows[4].add(this.asinKey);
        this.sinKey.setActionCommand("sin");
        this.sinKey.addActionListener(this);
        this.cosKey.setActionCommand("cos");
        this.cosKey.addActionListener(this);
        this.tanKey.setActionCommand("tan");
        this.tanKey.addActionListener(this);
        this.asinKey.setActionCommand("asin");
        this.asinKey.addActionListener(this);
        this.rows[5].setLayout(new FlowLayout(0));
        this.rows[5].add(this.numericKeys[0]);
        this.rows[5].add(this.acosKey);
        this.rows[5].add(this.atanKey);
        this.rows[5].add(this.atan2Key);
        this.rows[5].add(this.expKey);
        this.rows[5].add(this.sqrtKey);
        this.rows[5].add(this.ceilKey);
        this.acosKey.setActionCommand("acos");
        this.acosKey.addActionListener(this);
        this.atanKey.setActionCommand("atan");
        this.atanKey.addActionListener(this);
        this.atan2Key.setActionCommand("atan2");
        this.atan2Key.addActionListener(this);
        this.expKey.setActionCommand("exp");
        this.expKey.addActionListener(this);
        this.sqrtKey.setActionCommand("sqrt");
        this.sqrtKey.addActionListener(this);
        this.ceilKey.setActionCommand("ceil");
        this.ceilKey.addActionListener(this);
        this.rows[6].setLayout(new FlowLayout(0));
        this.rows[6].add(this.floorKey);
        this.rows[6].add(this.rintKey);
        this.rows[6].add(this.roundKey);
        this.rows[6].add(this.randomKey);
        this.rows[6].add(this.leftShiftKey);
        this.rows[6].add(this.rightShiftKey);
        this.rows[6].add(this.unRightShiftKey);
        this.floorKey.setActionCommand("floor");
        this.floorKey.addActionListener(this);
        this.rintKey.setActionCommand("rint");
        this.rintKey.addActionListener(this);
        this.roundKey.setActionCommand("round");
        this.roundKey.addActionListener(this);
        this.randomKey.setActionCommand("random");
        this.randomKey.addActionListener(this);
        this.leftShiftKey.setActionCommand("<<");
        this.leftShiftKey.addActionListener(this);
        this.rightShiftKey.setActionCommand(">>");
        this.rightShiftKey.addActionListener(this);
        this.unRightShiftKey.setActionCommand(">>>");
        this.unRightShiftKey.addActionListener(this);
        this.rows[7].setLayout(new FlowLayout(0));
        this.rows[7].add(this.bitORKey);
        this.rows[7].add(this.bitANDKey);
        this.rows[7].add(this.bitComplementKey);
        this.rows[7].add(this.greaterEqKey);
        this.rows[7].add(this.greaterKey);
        this.rows[7].add(this.lessEqKey);
        this.rows[7].add(this.lessKey);
        this.bitORKey.setActionCommand("|");
        this.bitORKey.addActionListener(this);
        this.bitANDKey.setActionCommand("&");
        this.bitANDKey.addActionListener(this);
        this.bitComplementKey.setActionCommand("~");
        this.bitComplementKey.addActionListener(this);
        this.greaterEqKey.setActionCommand(">=");
        this.greaterEqKey.addActionListener(this);
        this.greaterKey.setActionCommand(">");
        this.greaterKey.addActionListener(this);
        this.lessEqKey.setActionCommand("<=");
        this.lessEqKey.addActionListener(this);
        this.lessKey.setActionCommand("<");
        this.lessKey.addActionListener(this);
        this.rows[8].setLayout(new FlowLayout(0));
        this.rows[8].add(this.notEqKey);
        this.rows[8].add(this.equalsToKey);
        this.rows[8].add(this.leftBraceKey);
        this.rows[8].add(this.rightBraceKey);
        this.rows[8].add(this.equalsKey);
        this.notEqKey.setActionCommand("!=");
        this.notEqKey.addActionListener(this);
        this.equalsToKey.setActionCommand("==");
        this.equalsToKey.addActionListener(this);
        this.leftBraceKey.setActionCommand("(");
        this.leftBraceKey.addActionListener(this);
        this.rightBraceKey.setActionCommand(")");
        this.rightBraceKey.addActionListener(this);
        this.equalsKey.setActionCommand("=");
        this.equalsKey.addActionListener(this);
        calculatorPane.setLayout(new BoxLayout(calculatorPane, 1));
        JPanel[] jPanelArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            JPanel jPanel = jPanelArray[n2];
            calculatorPane.add(jPanel);
            ++n2;
        }
        this.calcFrame.pack();
        this.calcFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == null || actionCommand.trim().length() <= 0) {
            return;
        }
        int number = -1;
        try {
            number = Integer.parseInt(actionCommand);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number >= 0) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + number);
            this.result.setText("");
        } else if (actionCommand.equals("reset")) {
            this.expressionText.setText("");
            this.result.setText("");
        } else if (actionCommand.equals("/")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "/");
        } else if (actionCommand.equals("*")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "*");
        } else if (actionCommand.equals("-")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "-");
        } else if (actionCommand.equals("+")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "+");
        } else if (actionCommand.equals("<<")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "<<");
        } else if (actionCommand.equals(">>")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ">>");
        } else if (actionCommand.equals(">>>")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ">>>");
        } else if (actionCommand.equals("|")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "|");
        } else if (actionCommand.equals("&")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "&");
        } else if (actionCommand.equals("~")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "~");
        } else if (actionCommand.equals(">=")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ">=");
        } else if (actionCommand.equals(">")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ">");
        } else if (actionCommand.equals("<=")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "<=");
        } else if (actionCommand.equals("<")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "<");
        } else if (actionCommand.equals("!=")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "!=");
        } else if (actionCommand.equals("==")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "==");
        } else if (actionCommand.equals("(")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + "(");
        } else if (actionCommand.equals(")")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ")");
        } else if (actionCommand.equals(".")) {
            this.expressionText.setText(String.valueOf(this.expressionText.getText()) + ".");
        } else if (this.expressionText.getText() != null && this.expressionText.getText().trim().length() > 0) {
            String expression = "";
            if (actionCommand.equals("=")) {
                expression = this.expressionText.getText();
            } else if (actionCommand.equals("abs")) {
                expression = "abs(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("sin")) {
                expression = "sin(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("cos")) {
                expression = "cos(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("tan")) {
                expression = "tan(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("asin")) {
                expression = "asin(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("acos")) {
                expression = "acos(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("atan")) {
                expression = "atan(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("atan2")) {
                expression = "atan2(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("exp")) {
                expression = "exp(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("log")) {
                expression = "log(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("sqrt")) {
                expression = "sqrt(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("ceil")) {
                expression = "ceil(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("floor")) {
                expression = "floor(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("rint")) {
                expression = "rint(" + this.expressionText.getText() + ")";
            } else if (actionCommand.equals("round")) {
                expression = "round(" + this.expressionText.getText() + ")";
            }
            this.result.setText(this.calc.getResult(expression));
            this.expressionText.setText("");
        } else if (actionCommand.equals("random")) {
            this.result.setText(this.calc.getResult("random(" + this.expressionText.getText() + ")"));
            this.expressionText.setText("");
        }
    }

    public static void main(String[] args) {
        ExpressionEvaluatorUI sc = new ExpressionEvaluatorUI();
        sc.drawCalculator();
    }
}

