/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static final boolean isPropertyEditable(Class beanClass, String property) throws IntrospectionException {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(beanClass, property);
        return descriptor == null ? false : descriptor.getWriteMethod() != null;
    }

    public static final Class getPropertyType(Class beanClass, String property) throws IntrospectionException {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(beanClass, property);
        return descriptor == null ? null : descriptor.getPropertyType();
    }

    public static final Object getPropertyValue(Object bean, String property) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object propertyValue = null;
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(bean.getClass(), property);
        if (descriptor != null && descriptor.getReadMethod() != null) {
            propertyValue = descriptor.getReadMethod().invoke(bean, null);
        }
        return propertyValue;
    }

    public static final void setPropertyValue(Object bean, String property, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(bean.getClass(), property);
        if (descriptor != null && descriptor.getWriteMethod() != null) {
            descriptor.getWriteMethod().invoke(bean, value);
        }
    }

    public static final PropertyDescriptor getPropertyDescriptor(Class beanClass, String property) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        int length = descriptors == null ? 0 : descriptors.length;
        int i = 0;
        while (i < length) {
            if (descriptors[i].getDisplayName().equals(property)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }
}

