/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.utils.Utilities;
import org.vedantatree.expressionoasis.utils.XMLErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLUtils {
    private static Log LOGGER = LogFactory.getLog(XMLUtils.class);

    public static Document parseXML(URL xmlDocumentURL, String xsdPath) throws ExpressionEngineException {
        Utilities.assertNotNullArgument(xmlDocumentURL);
        try {
            return XMLUtils.parseXML(xmlDocumentURL.openStream(), xsdPath);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problem while parsing the XML from URL. url[" + xmlDocumentURL.getPath() + "]"));
            throw new ExpressionEngineException("Problem while parsing the XML from URL. url[" + xmlDocumentURL.getPath() + "]", 6, e);
        }
    }

    public static Document parseXML(File xmlFile, String xsdPath) throws ExpressionEngineException {
        Utilities.assertNotNullArgument(xmlFile);
        try {
            return XMLUtils.parseXML(new FileInputStream(xmlFile), xsdPath);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("File not found while parsing the xml. file[" + xmlFile.getAbsolutePath() + "]"));
            throw new ExpressionEngineException("File not found while parsing the xml. file[" + xmlFile.getAbsolutePath() + "]", 6, e);
        }
    }

    public static Document parseXML(InputStream is, String xsdPath) throws ExpressionEngineException {
        LOGGER.debug((Object)"entering : parseXML");
        Utilities.assertNotNullArgument(is);
        DOMParser parser = new DOMParser();
        try {
            if (xsdPath != null) {
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)xsdPath);
            }
            parser.setErrorHandler((ErrorHandler)new XMLErrorHandler());
            parser.parse(new InputSource(is));
            return parser.getDocument();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Problem while parsing XML.", (Throwable)e);
            throw new ExpressionEngineException("Problem while parsing XML.", 7, e);
        }
    }

    public static void main(String[] args) {
    }
}

