/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.io.File;
import java.net.URL;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.Utilities;
import org.vedantatree.expressionoasis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathUtils {
    private static Log LOGGER = LogFactory.getLog(XPathUtils.class);

    public static ValueObject evaluateExpressionToValueObject(Document document, String xPathExpression) throws ExpressionEngineException {
        XObject xObject = XPathUtils.evaluateExpression(document, xPathExpression);
        try {
            if (xObject.getType() == 1) {
                return new ValueObject(new Boolean(xObject.bool()), Type.BOOLEAN);
            }
            if (xObject.getType() == 2) {
                return new ValueObject(new Double(xObject.num()), Type.DOUBLE);
            }
            if (xObject.getType() == 3) {
                return new ValueObject(xObject.str(), Type.STRING);
            }
            if (xObject.getType() == 4) {
                return new ValueObject(xObject.object(), Type.XML);
            }
            return new ValueObject(xObject.object(), Type.ANY_TYPE);
        }
        catch (TransformerException e) {
            ExpressionEngineException eex = new ExpressionEngineException("Problem while evaluating XPath Expression-[" + xPathExpression + "]", 7, e);
            LOGGER.error((Object)"Problem while evaluating XPath Expression", (Throwable)eex);
            throw eex;
        }
    }

    public static String getXMLString(Object obj) {
        Utilities.assertNotNullArgument(obj);
        if (obj instanceof XNodeSet) {
            return ((XNodeSet)obj).str();
        }
        return obj.toString();
    }

    public static XObject evaluateExpression(Document document, String xPathExpression) throws ExpressionEngineException {
        XObject expressionValue = null;
        try {
            expressionValue = XPathAPI.eval((Node)document, (String)xPathExpression);
        }
        catch (TransformerException e) {
            ExpressionEngineException eex = new ExpressionEngineException("Problem while parsing xPathExpression[" + xPathExpression + "]", 7, e);
            LOGGER.error((Object)"Problem while parsing XML", (Throwable)eex);
            throw eex;
        }
        return expressionValue;
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("file:\\F:\\temp\\test.xml");
        System.out.println(url.getFile());
        File file = new File(url.getFile());
        System.out.println(file.getPath());
        Document doc = XMLUtils.parseXML(url, null);
        ValueObject value = XPathUtils.evaluateExpressionToValueObject(doc, "/new1/book/@name");
        System.out.println("value[" + value.getValue() + "]");
        System.out.println("valueXObject[" + XPathUtils.evaluateExpression(doc, "/new1/book/@name").toString() + "]");
    }
}

