/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.grammar.DefaultXMLGrammar;
import org.vedantatree.expressionoasis.grammar.ExpressionToken;
import org.vedantatree.expressionoasis.grammar.Grammar;
import org.vedantatree.expressionoasis.utils.StringUtils;

public final class Parser {
    private static Log LOGGER = LogFactory.getLog(Parser.class);
    private final Grammar grammar;

    public Parser() {
        throw new UnsupportedOperationException("This constructor is no longer supported, since Parse is always initiated from Compiler with Grammar instance");
    }

    public Parser(Grammar grammar) {
        if (grammar == null) {
            throw new IllegalArgumentException("DefaultXMLGrammar object must not be null for the parser.");
        }
        this.grammar = grammar;
    }

    public final List<ExpressionToken> parse(String expression) throws ExpressionEngineException {
        if (!StringUtils.isQualifiedString(expression)) {
            throw new ExpressionEngineException("Passed expression is not a qualified text.");
        }
        ArrayList<ExpressionToken> tokenList = new ArrayList<ExpressionToken>();
        this.parse(expression, tokenList, 0, 0);
        return tokenList;
    }

    private void parse(String expression, List<ExpressionToken> tokenList, int currentPosition, int offset) throws ExpressionEngineException {
        String currentToken;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("expression[" + expression + "] pointer[" + currentPosition + "] offset[" + offset + "]"));
        }
        String currentExpressionCharacter = expression.substring(currentPosition, currentPosition + 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("next-token[" + currentExpressionCharacter + "] currentToken[" + this.getCurrentToken(expression, offset, currentPosition) + "] + lastToken[" + this.getLastToken(tokenList) + "]"));
        }
        int index = offset;
        if (this.grammar.isDelimiter(currentExpressionCharacter) && !this.grammar.isApproachable(String.valueOf(this.getCurrentToken(expression, offset, currentPosition)) + currentExpressionCharacter)) {
            currentToken = this.getCurrentToken(expression, offset, currentPosition);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("delimiter+notApproachable-currentToken[" + currentToken + "]"));
            }
            if (StringUtils.isQualifiedString(currentToken)) {
                this.checkValid(currentToken, offset);
                tokenList.add(new ExpressionToken(currentToken, index));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("token-added[" + tokenList + "]"));
                }
            }
            offset = currentPosition + 1;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("increased-offset[" + offset + "]"));
            }
            if (this.isPreviousTokenADelimiter(tokenList)) {
                int lastIndex = tokenList.size() - 1;
                String previousToken = tokenList.get(lastIndex).getValue();
                String temp = String.valueOf(previousToken) + currentExpressionCharacter;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("previousTokenDelimiter-previousToken[" + previousToken + "] temp[" + temp + "]"));
                }
                if (this.grammar.isDelimiter(temp)) {
                    index -= previousToken.length();
                    currentExpressionCharacter = temp;
                    ExpressionToken lastToken = tokenList.remove(lastIndex);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("temp-is-delimiter-removedLastToken[" + lastToken + "]"));
                    }
                }
            }
            if (StringUtils.isQualifiedString(currentExpressionCharacter)) {
                tokenList.add(new ExpressionToken(currentExpressionCharacter, index));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("token-added[" + tokenList + "]"));
                }
            }
        } else if (this.isPreviousTokenADelimiter(tokenList) && this.grammar.isApproachable(String.valueOf(this.getLastToken(tokenList)) + this.getCurrentToken(expression, offset, currentPosition))) {
            String lastToken = this.getLastToken(tokenList);
            offset -= lastToken.length();
            ExpressionToken removedToken = tokenList.remove(tokenList.size() - 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("previousToken-delimiter-approachable-removedLastToken[" + lastToken + "] removedToken[" + removedToken + "]"), (Throwable)new Exception("case found"));
            }
        }
        if (++currentPosition < expression.length()) {
            this.parse(expression, tokenList, currentPosition, offset);
        } else {
            currentToken = this.getCurrentToken(expression, offset, currentPosition);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("lastToken[" + currentToken + "]"));
            }
            if (StringUtils.isQualifiedString(currentToken)) {
                this.checkValid(currentToken, offset);
                tokenList.add(new ExpressionToken(currentToken, index));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("token-added[" + tokenList + "]"));
                }
            }
        }
    }

    private boolean isPreviousTokenADelimiter(List<ExpressionToken> tokens) {
        String lastToken = this.getLastToken(tokens);
        boolean lastDelimiter = lastToken != null && this.grammar.isDelimiter(lastToken);
        return lastDelimiter;
    }

    private String getLastToken(List<ExpressionToken> tokens) {
        int size = tokens.size();
        return size > 0 ? tokens.get(size - 1).getValue() : null;
    }

    private String getCurrentToken(String expression, int offset, int pointer) {
        String token = expression.substring(offset, pointer);
        return this.grammar.isIgnoreBlank() ? token.trim() : token;
    }

    private void checkValid(String currentToken, int offset) throws ExpressionEngineException {
        if (!this.grammar.isAllowed(currentToken)) {
            throw new ExpressionEngineException("Invalid token \"" + currentToken + "\" at position " + (offset + 1));
        }
    }

    public static void main(String[] args) throws ExpressionEngineException {
        Parser parser = new Parser(new DefaultXMLGrammar());
        List<ExpressionToken> tokens = parser.parse("pow(2,null)");
        System.out.println(tokens);
    }
}

