/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.config;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.simpleframework.xml.core.Persister;
import org.vedantatree.expressionoasis.config.ExpressionOasisConfig;

public class ConfigFactory {
    public static final String CONFIG_FILE_PATH_KEY = "EXPRESSION_OASIS_CONFIG_FILE";
    private static String CONFIG_FILE_PATH = "config.xml";
    private static URL CONFIG_FILE_URL = null;
    private static ExpressionOasisConfig instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionOasisConfig getConfig() {
        if (instance != null) return instance;
        Class<ConfigFactory> clazz = ConfigFactory.class;
        synchronized (ConfigFactory.class) {
            if (instance != null) return instance;
            String configFilePath = System.getProperty(CONFIG_FILE_PATH_KEY);
            boolean externalPathSet = false;
            if (configFilePath != null && configFilePath.trim().length() > 0) {
                CONFIG_FILE_PATH = configFilePath;
                try {
                    CONFIG_FILE_URL = new URL(CONFIG_FILE_PATH);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                externalPathSet = true;
            }
            if (!externalPathSet) {
                System.out.println("No custom configuraiton file is set from outside using System Properties. ExpressionOasis will look for config.xml in class path.");
            } else {
                System.out.println("Configuration file path is specified in system properties for key[EXPRESSION_OASIS_CONFIG_FILE]. ExpressionOasis will load the configuration from: " + CONFIG_FILE_PATH);
            }
            Persister serializer = new Persister();
            try {
                InputStream stream = externalPathSet ? CONFIG_FILE_URL.openStream() : ConfigFactory.class.getClassLoader().getResourceAsStream(CONFIG_FILE_PATH);
                instance = (ExpressionOasisConfig)serializer.read(ExpressionOasisConfig.class, stream);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading ExpressionOasis configuration. config.xml path[" + CONFIG_FILE_PATH + "]", e);
            }
            return instance;
        }
    }
}

