/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.vedantatree.expressionoasis.config.ExpressionConfig;
import org.vedantatree.expressionoasis.config.FunctionProviderConfig;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.grammar.Grammar;

@Root(name="expressionOasisConfig")
public class ExpressionOasisConfig {
    @Element(name="cacheCompiledExpressions")
    private boolean cacheCompiledExpressions;
    @Element(name="grammarClass")
    private String grammarClass;
    @Element(name="grammarPath")
    private String grammarPath;
    @ElementList(name="functionProviders", entry="functionProvider")
    private List<FunctionProviderConfig> functionProviderConfigs;
    @ElementList(name="expressions", entry="expression")
    private List<ExpressionConfig> expressionConfigs;
    private final List<FunctionProvider> functionProviders = new ArrayList<FunctionProvider>();

    public boolean shouldCacheCompiledExpressions() {
        return this.cacheCompiledExpressions;
    }

    public List<ExpressionConfig> getExpressionConfigs() {
        return Collections.unmodifiableList(this.expressionConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FunctionProvider> getFunctionProviders() {
        if (this.functionProviders.isEmpty()) {
            List<FunctionProvider> list = this.functionProviders;
            synchronized (list) {
                if (this.functionProviders.isEmpty()) {
                    for (FunctionProviderConfig functionProviderConfig : this.functionProviderConfigs) {
                        this.functionProviders.add(functionProviderConfig.getFunctionProvider());
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.functionProviders);
    }

    public Grammar getGrammar() {
        try {
            return (Grammar)Class.forName(this.grammarClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while instantiating the Grammar object. Grammar Class specified in config.xml[" + this.grammarClass + "]", e);
        }
    }

    public String getGrammarPath() {
        return this.grammarPath;
    }
}

