/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import java.util.HashMap;
import java.util.Map;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.utils.StringUtils;

public abstract class UnaryOperatorExpression
implements Expression {
    private static Map typePairMapping = new HashMap();
    private Expression operandExpression;

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        this.operandExpression = (Expression)parameters;
        if (validate) {
            this.validate(expressionContext);
        }
    }

    public Expression getOperandExpression() {
        return this.operandExpression;
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        HashMap typeMapping = (HashMap)typePairMapping.get(this.getClass());
        return (Type)typeMapping.get(this.operandExpression.getReturnType());
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.operandExpression = null;
    }

    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        HashMap typeMapping = (HashMap)typePairMapping.get(this.getClass());
        if (typeMapping == null) {
            throw new ExpressionEngineException("No type mapping specified for class \"" + this.getClass().getName() + "\"");
        }
        if (typeMapping.get(this.operandExpression.getReturnType()) == null) {
            String prefix = StringUtils.getLastToken(this.getClass().getName(), ".");
            prefix = prefix.substring(0, prefix.length() - "Expression".length());
            throw new ExpressionEngineException("Operand of type: [\"" + this.operandExpression.getReturnType() + "\"] is not supported by operator \"" + prefix + "\"", 100, null);
        }
    }

    protected static final void addTypePair(Class clazz, Type operandType, Type resultType) {
        if (clazz == null || !UnaryOperatorExpression.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("\"" + clazz.getName() + "\" is not a valid unary operator expression class.");
        }
        HashMap<Type, Type> typeMapping = (HashMap<Type, Type>)typePairMapping.get(clazz);
        if (typeMapping == null) {
            typeMapping = new HashMap<Type, Type>();
            typePairMapping.put(clazz, typeMapping);
        }
        typeMapping.put(operandType, resultType);
    }

    public String toString() {
        String prefix = StringUtils.getLastToken(this.getClass().getName(), ".");
        prefix = prefix.substring(0, prefix.length());
        return String.valueOf(prefix) + ":[" + this.operandExpression + "]";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
        this.operandExpression.accept(visitor);
    }
}

