/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class DivideExpression
extends BinaryOperatorExpression {
    static {
        DivideExpression.addTypePair(DivideExpression.class, Type.LONG, Type.LONG, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.LONG, Type.DOUBLE, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.DOUBLE, Type.LONG, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.OBJECT, Type.OBJECT, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.DOUBLE, Type.OBJECT, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.OBJECT, Type.DOUBLE, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.LONG, Type.OBJECT, Type.DOUBLE);
        DivideExpression.addTypePair(DivideExpression.class, Type.OBJECT, Type.LONG, Type.DOUBLE);
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return Type.DOUBLE;
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Double result = null;
        Type returnType = this.getReturnType();
        if (leftValue != null && rightValue != null && returnType == Type.DOUBLE) {
            result = new Double(((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue());
        }
        return new ValueObject(result, returnType);
    }
}

