/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.relational;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class EQExpression
extends BinaryOperatorExpression {
    static {
        EQExpression.addTypePair(EQExpression.class, Type.LONG, Type.LONG, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.DOUBLE, Type.DOUBLE, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.STRING, Type.STRING, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.LONG, Type.DOUBLE, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.DOUBLE, Type.LONG, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.BOOLEAN, Type.BOOLEAN, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.OBJECT, Type.OBJECT, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.LONG, Type.OBJECT, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.OBJECT, Type.LONG, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.DOUBLE, Type.OBJECT, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.OBJECT, Type.DOUBLE, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.STRING, Type.OBJECT, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.OBJECT, Type.STRING, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.BOOLEAN, Type.OBJECT, Type.BOOLEAN);
        EQExpression.addTypePair(EQExpression.class, Type.OBJECT, Type.BOOLEAN, Type.BOOLEAN);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Type leftType = this.leftOperandExpression.getReturnType();
        Type rightType = this.rightOperandExpression.getReturnType();
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        ValueObject result = null;
        if (leftType == Type.LONG && rightType == Type.LONG) {
            Boolean value = ((Long)leftValue).longValue() == ((Long)rightValue).longValue() ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.DOUBLE && rightType == Type.DOUBLE) {
            Boolean value = ((Double)leftValue).doubleValue() == ((Double)rightValue).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.STRING && rightType == Type.STRING) {
            Boolean value = leftValue.equals(rightValue) ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.DOUBLE && rightType == Type.LONG) {
            Boolean value = (Double)leftValue == (double)((Long)rightValue).longValue() ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.LONG && rightType == Type.DOUBLE) {
            Boolean value = (double)((Long)leftValue).longValue() == (Double)rightValue ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.BOOLEAN && rightType == Type.BOOLEAN) {
            Boolean value = leftValue.equals(rightValue) ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.OBJECT || rightType == Type.OBJECT) {
            Boolean value = leftValue == null || rightValue == null ? Boolean.valueOf(leftValue == rightValue) : (leftValue.equals(rightValue) ? Boolean.TRUE : Boolean.FALSE);
            result = new ValueObject(value, Type.BOOLEAN);
        }
        return result;
    }
}

