/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.extensions;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.ExpressionEngine;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.StringUtils;
import org.vedantatree.expressionoasis.utils.XMLUtils;
import org.vedantatree.expressionoasis.utils.XPathUtils;
import org.w3c.dom.Document;

public class XMLFunctionProvider
implements FunctionProvider {
    private static Log LOGGER = LogFactory.getLog(XMLFunctionProvider.class);
    private ExpressionContext expressionContext;
    private Object xmlPathURL;
    private Document xmlDocument;

    public XMLFunctionProvider() {
        ExpressionEngine.getGrammar().addFunction("xml");
    }

    @Override
    public Type getFunctionType(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        this.ensureInitialized();
        this.checkFunctionValid(functionName);
        return Type.STRING;
    }

    @Override
    public ValueObject getFunctionValue(String functionName, ValueObject[] parameters) throws ExpressionEngineException {
        this.ensureInitialized();
        this.checkFunctionValid(functionName);
        if (parameters.length != 1) {
            throw new ExpressionEngineException("Only one parameter is expected however got " + parameters.length);
        }
        if (parameters[0].getValueType() != Type.STRING) {
            throw new ExpressionEngineException("Only string type parameter is expected however got parameter of type[" + parameters[0].getValueType() + "]");
        }
        try {
            ValueObject value = XPathUtils.evaluateExpressionToValueObject(this.xmlDocument, (String)parameters[0].getValue());
            if (value.getValueType() == Type.XML) {
                value = new ValueObject(XPathUtils.getXMLString(value.getValue()), Type.STRING);
            } else if (value.getValueType() == Type.ANY_TYPE) {
                LOGGER.error((Object)("Result value should be of String/Number/Boolean type, not XML nodes, null or others. result-value[" + value + "]"));
                throw new ExpressionEngineException("Result value should be of String type, not XML nodes or others. result-value[" + value + "]");
            }
            return value;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Problem while evaluating the XPath Expression. expression[" + parameters[0].getValue() + "] rootCause[" + e.getMessage() + "]"), (Throwable)e);
            throw e instanceof ExpressionEngineException ? (ExpressionEngineException)e : new ExpressionEngineException("Problem while evaluating the XPath Expression. expression[" + parameters[0].getValue() + "] rootCause[" + e.getMessage() + "]", e);
        }
    }

    @Override
    public void initialize(ExpressionContext expressionContext) throws ExpressionEngineException {
        this.expressionContext = expressionContext;
        this.xmlPathURL = expressionContext.getContextProperty("XML_PATH_URL");
        if (this.xmlPathURL != null) {
            this.ensureInitialized();
        }
    }

    private void ensureInitialized() throws ExpressionEngineException {
        if (this.xmlDocument != null) {
            return;
        }
        this.xmlPathURL = this.expressionContext.getContextProperty("XML_PATH_URL");
        if (this.xmlPathURL == null) {
            throw new ExpressionEngineException("No XML Path URL is specified");
        }
        if (!(this.xmlPathURL instanceof URL)) {
            throw new ExpressionEngineException("Specified XML Path URL is not a instance of URL class. specified-url[" + this.xmlPathURL + "]");
        }
        if (!StringUtils.isQualifiedString(((URL)this.xmlPathURL).getPath())) {
            throw new ExpressionEngineException("Specified XML Path URL is not a well formed path. specified-url[" + this.xmlPathURL + "]");
        }
        this.xmlDocument = XMLUtils.parseXML((URL)this.xmlPathURL, null);
        this.xmlDocument.getDocumentElement().normalize();
    }

    @Override
    public boolean supportsFunction(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        return "xml".equalsIgnoreCase(functionName) && parameterTypes != null && parameterTypes.length == 1 && parameterTypes[0] == Type.STRING;
    }

    private void checkFunctionValid(String functionName) throws ExpressionEngineException {
        if (!"xml".equalsIgnoreCase(functionName)) {
            throw new ExpressionEngineException("Only XML function is supported. functionName[" + functionName + "]");
        }
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("file:\\F:\\temp\\test.xml");
        System.out.println(url.getFile());
        File file = new File(url.getFile());
        System.out.println(file.getPath());
        ExpressionContext expressionContext = new ExpressionContext();
        expressionContext.setContextProperty("XML_PATH_URL", url);
        XMLFunctionProvider xmlFunctionProvider = new XMLFunctionProvider();
        xmlFunctionProvider.initialize(expressionContext);
        ValueObject value = xmlFunctionProvider.getFunctionValue("xml", new ValueObject[]{new ValueObject("/new1/book/@name", Type.STRING)});
        System.out.println("value[" + value.getValue() + "]");
    }
}

