/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StringUtils {
    private static Log LOGGER = LogFactory.getLog(StringUtils.class);

    private StringUtils() {
    }

    public static void assertQualifiedArgument(String attribute, String attributeName) {
        if (!StringUtils.isQualifiedString(attribute)) {
            IllegalArgumentException iae = new IllegalArgumentException("Null or zero length value found. attribute-name-message[" + attributeName + "] value[" + attribute + "]");
            LOGGER.error((Object)iae);
            throw iae;
        }
    }

    public static void assertQualifiedArgument(String attribute) {
        if (!StringUtils.isQualifiedString(attribute)) {
            IllegalArgumentException iae = new IllegalArgumentException("Null or zero length string found. str[" + attribute + "]");
            LOGGER.error((Object)iae);
            throw iae;
        }
    }

    public static final boolean isQualifiedString(String str) {
        return str != null && !str.trim().equals("");
    }

    public static final String blankString(int length) {
        StringBuffer buffer = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public static final String getLastToken(String value, String delimiter) {
        String result = null;
        StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
        while (tokenizer.hasMoreElements()) {
            result = (String)tokenizer.nextElement();
        }
        return result;
    }

    public static final String objectArrayToString(Object[] objectArray) {
        StringBuffer arrayString = new StringBuffer("{");
        if (objectArray == null) {
            arrayString.append("null");
        } else if (objectArray.length == 0) {
            arrayString.append("empty");
        } else {
            boolean first = true;
            int i = 0;
            while (i < objectArray.length) {
                if (!first) {
                    arrayString.append(", ");
                }
                arrayString.append(objectArray[i]);
                first = false;
                ++i;
            }
        }
        arrayString.append("}");
        return arrayString.toString();
    }

    public static void main(String[] args) {
        Object[] array = new Object[]{"1", "2", "Ram"};
        System.out.println(StringUtils.objectArrayToString(array));
    }
}

