/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.utils.StringUtils;

public class Utilities {
    private static Log logger = LogFactory.getLog(Utilities.class);

    public static void assertNotNullArgument(Object attribute, String attributeName) {
        if (attribute instanceof String) {
            StringUtils.assertQualifiedArgument((String)attribute, attributeName);
        } else if (attribute == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Null Object specified as value of attribute. attribute-name-message[" + attributeName + "]");
            logger.error((Object)iae);
            throw iae;
        }
    }

    public static void assertNotNullArgument(Object attribute) {
        if (attribute instanceof String) {
            StringUtils.assertQualifiedArgument((String)attribute);
        } else if (attribute == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Null Object specified as attribute");
            logger.error((Object)iae);
            throw iae;
        }
    }

    public static boolean validateEmailID(String emailID) {
        if (emailID.indexOf(64) == -1 || emailID.indexOf(64) != emailID.lastIndexOf(64) || emailID.lastIndexOf(64) == emailID.length() - 1 || emailID.indexOf(64) == 0) {
            return false;
        }
        if (emailID.lastIndexOf(46) == -1 || emailID.length() - emailID.lastIndexOf(46) - 1 < 2) {
            return false;
        }
        if (emailID.indexOf(64) > emailID.lastIndexOf(46) || emailID.lastIndexOf(46) - emailID.indexOf(64) == 1) {
            return false;
        }
        if (emailID.indexOf(32) != -1) {
            return false;
        }
        String spclChars = ";:?<>!~`!#$%^&*()+=|\\/'\"";
        int i = 0;
        while (i < spclChars.length()) {
            if (emailID.indexOf(spclChars.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertCamelToTitleString(String inpString) {
        while (inpString.indexOf("_") != -1) {
            int k = inpString.indexOf(95);
            inpString = String.valueOf(inpString.substring(0, k)) + inpString.substring(k + 1);
        }
        int i = 0;
        while (i < inpString.length()) {
            String ch;
            String rg = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (i != 0 && rg.indexOf(ch = "" + inpString.charAt(i)) != -1) {
                inpString = String.valueOf(inpString.substring(0, i)) + " " + inpString.substring(i);
                i += 2;
            }
            ++i;
        }
        return inpString;
    }

    public static void printMapEntries(Map map) {
        logger.info((Object)"------------------------------------------");
        logger.info((Object)"Printing map >> ");
        int size = map.size();
        Object[] keys = map.keySet().toArray();
        int i = 0;
        while (i < size) {
            logger.info((Object)("entry[" + keys[i] + "] = " + map.get(keys[i])));
            ++i;
        }
        logger.info((Object)"-------------------------------------------");
    }

    public static int[] getIndexArray(String combinedString) {
        System.out.println("Combined string is [" + combinedString + "]");
        String[] idArray = combinedString.split(":");
        int[] idIntArray = new int[idArray.length];
        int i = 0;
        while (i < idArray.length) {
            idIntArray[i] = Integer.parseInt(idArray[i].trim());
            System.out.println("Long id at index [" + i + "] is [" + idIntArray[i] + "]");
            ++i;
        }
        return idIntArray;
    }
}

