/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis;

import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.interpreter.calculator.expressionoasis.ExpressionOasisDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculator.expressionoasis.ExpressionOasisResourcePowerModelCalculator;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.CalculatorFactory;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import de.fzi.power.specification.PowerModelSpecification;
import de.fzi.power.specification.SpecificationPackage;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;

public class CalculatorFactoryImpl
implements CalculatorFactory {
    private static final EClass COMPATIBLE_POWER_MODEL_SPEC_ECLASS = SpecificationPackage.Literals.DECLARATIVE_POWER_MODEL_SPECIFICATION;

    public boolean isCompatibleWith(PowerModelSpecification specification) {
        return COMPATIBLE_POWER_MODEL_SPEC_ECLASS.isInstance((Object)Objects.requireNonNull(specification, "Given specification must not be null."));
    }

    public int getPriority() {
        return 100;
    }

    public AbstractDistributionPowerModelCalculator instantiateDistributionPowerModelCalculator(PowerProvidingEntity forEntity) {
        return new ExpressionOasisDistributionPowerModelCalculator(Objects.requireNonNull(forEntity, "Given PowerProvidingEntity must not be null."));
    }

    public IResourcePowerModelCalculator instantiateResourcePowerModelCalculator(ResourcePowerBinding binding) {
        return new ExpressionOasisResourcePowerModelCalculator(Objects.requireNonNull(binding, "Given PowerConsumingResource must not be null."));
    }
}

