/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.custom;

import de.fzi.power.binding.AbstractFixedFactorValue;
import de.fzi.power.binding.FixedFactorValueDimensionless;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.binding.util.BindingSwitch;
import de.fzi.power.interpreter.InterpreterUtils;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.MeasuredValuesCompositeValueObject;
import de.fzi.power.interpreter.calculator.expressionoasis.helper.ExpressionOasisHelper;
import de.fzi.power.specification.ConsumptionFactor;
import de.fzi.power.specification.MeasuredFactor;
import de.fzi.power.specification.util.SpecificationSwitch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.DefaultVariableProvider;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

final class ConsumptionFactorsVariableProvider
extends DefaultVariableProvider {
    private final Map<MetricDescription, String> measuredFactors;
    private final Map<String, Unit<Quantity>> defaultUnits;
    private final Map<MetricDescription, List<Measure<Number, Quantity>>> measuredValues;
    private final SpecificationSwitch<Void> consumptionFactorSwitch = new SpecificationSwitch<Void>(){

        public Void caseMeasuredFactor(MeasuredFactor object) {
            if (ConsumptionFactorsVariableProvider.this.measuredFactors.containsKey(object.getMetricType())) {
                throw new IllegalStateException("Consumption factor of metric type '" + object.getMetricType() + "' already present (name: '" + (String)ConsumptionFactorsVariableProvider.this.measuredFactors.get(object.getMetricType()) + "'): Only one per type supported!");
            }
            ConsumptionFactorsVariableProvider.this.measuredFactors.put(object.getMetricType(), object.getName());
            ConsumptionFactorsVariableProvider.this.defaultUnits.put(object.getName(), object.getMetricType().getDefaultUnit());
            return null;
        }
    };

    ConsumptionFactorsVariableProvider(EList<AbstractFixedFactorValue<?>> eList, Iterable<ConsumptionFactor> consumptionFactors) {
        this.defaultUnits = new HashMap<String, Unit<Quantity>>();
        this.measuredFactors = InterpreterUtils.createIdentifierMatchingHashMap();
        this.measuredValues = InterpreterUtils.createIdentifierMatchingHashMap();
        for (ConsumptionFactor consumptionFactor : consumptionFactors) {
            this.consumptionFactorSwitch.doSwitch((EObject)consumptionFactor);
        }
        for (AbstractFixedFactorValue fixedFactorValue : eList) {
            new BindingSwitch<Void>(){

                public Void caseFixedFactorValueDimensionless(FixedFactorValueDimensionless factor) {
                    Measure measure = factor.getValue();
                    ConsumptionFactorsVariableProvider.this.addVariable(factor.getBoundFactor().getName(), new ValueObject((Object)measure.doubleValue(measure.getUnit()), Type.DOUBLE));
                    return null;
                }

                public Void caseFixedFactorValuePower(FixedFactorValuePower factor) {
                    Measure measure = factor.getValue();
                    ConsumptionFactorsVariableProvider.this.addVariable(factor.getBoundFactor().getName(), new ValueObject((Object)measure.doubleValue(measure.getUnit()), Type.DOUBLE));
                    return null;
                }
            }.doSwitch((EObject)fixedFactorValue);
        }
    }

    Collection<MetricDescription> getMeasuredFactors() {
        return Collections.unmodifiableCollection(this.measuredFactors.keySet());
    }

    boolean providesMeasuredFactor(String measuredFactorName) {
        return this.measuredFactors.containsValue(Objects.requireNonNull(measuredFactorName));
    }

    boolean providesMeasuredFactor(MetricDescription measuredFactorMetric) {
        return this.measuredFactors.containsKey(Objects.requireNonNull(measuredFactorMetric));
    }

    private void internalAdd(MeasuringValue measuringValue) {
        assert (measuringValue != null);
        MetricDescription description = measuringValue.getMetricDesciption();
        if (this.providesMeasuredFactor(description)) {
            List<Measure<Number, Quantity>> valuesForFactor = this.measuredValues.get(description);
            if (valuesForFactor == null) {
                valuesForFactor = new ArrayList<Measure<Number, Quantity>>();
                this.measuredValues.put(description, valuesForFactor);
            }
            valuesForFactor.add((Measure<Number, Quantity>)measuringValue.getMeasureForMetric(description));
        }
    }

    void addMeasuredValue(MeasuringValue measuringValue) {
        if (measuringValue instanceof BasicMeasurement) {
            this.internalAdd(measuringValue);
        } else if (measuringValue instanceof TupleMeasurement) {
            for (MeasuringValue m : ((TupleMeasurement)measuringValue).getSubsumedMeasurements()) {
                this.addMeasuredValue(m);
            }
        }
    }

    void clearMeasuredValues() {
        this.measuredValues.clear();
    }

    public void initialize(ExpressionContext expressionContext) throws ExpressionEngineException {
        ExpressionOasisHelper.assertCorrectExpressionContext(expressionContext, ((Object)((Object)this)).getClass());
        super.initialize(expressionContext);
    }

    public Type getVariableType(String variableName) throws ExpressionEngineException {
        return this.providesMeasuredFactor(variableName) ? Type.DOUBLE : super.getVariableType(variableName);
    }

    public ValueObject getVariableValue(String variableName) throws ExpressionEngineException {
        return !this.providesMeasuredFactor(variableName) ? super.getVariableValue(variableName) : this.getVariableValueForMeasuredFactor(variableName);
    }

    private ValueObject getVariableValueForMeasuredFactor(String measuredFactorName) {
        assert (measuredFactorName != null && !measuredFactorName.isEmpty());
        Object result = null;
        MetricDescription metricOfVariable = null;
        for (Map.Entry<MetricDescription, String> entry : this.measuredFactors.entrySet()) {
            if (!entry.getValue().equals(measuredFactorName)) continue;
            metricOfVariable = entry.getKey();
            break;
        }
        assert (metricOfVariable != null);
        if (!this.measuredValues.containsKey(metricOfVariable)) {
            result = new ValueObject((Object)0.0, Type.DOUBLE);
        } else {
            List<Measure<Number, Quantity>> foundMeasures = this.measuredValues.get(metricOfVariable);
            ArrayList<Double> resultValues = new ArrayList<Double>(foundMeasures.size());
            for (Measure<Number, Quantity> foundMeasure : foundMeasures) {
                resultValues.add(foundMeasure.doubleValue(this.defaultUnits.get(measuredFactorName)));
            }
            result = foundMeasures.size() == 1 ? new ValueObject(resultValues.get(0), Type.DOUBLE) : new MeasuredValuesCompositeValueObject(resultValues);
        }
        return result;
    }

    public boolean supportsVariable(String variableName) throws ExpressionEngineException {
        return this.providesMeasuredFactor(variableName) || super.supportsVariable(variableName);
    }

    public void clear() {
        super.clear();
        this.clearMeasuredValues();
    }
}

