/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.energy;

import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Arrays;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Power;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public abstract class AbstractCumulativeEnergyCalculator {
    private final int numberOfInitSteps;
    private int calculatedEnergySamples;
    private final CircularDataContainer<Amount<Power>> powerSamplesRequiredForCalc;
    private final CircularDataContainer<Amount<Energy>> energySamplesRequiredForCalc;
    private Amount<Duration> samplingPeriod;
    private Amount<Duration> initialOffset;
    private Unit<Energy> resultUnit;
    private static final Amount<Duration> ZERO_DURATION = Amount.valueOf((long)0L, (Unit)SI.SECOND);
    private static final Amount<Duration> DEFAULT_SAMPLING_PERIOD = Amount.valueOf((long)10L, (Unit)SI.SECOND);

    protected AbstractCumulativeEnergyCalculator(int powerSamplesNeeded, int energySamplesNeeded, int numberOfInitSteps, Measurable<Duration> samplingPeriod, Measurable<Duration> initialOffset, Unit<Energy> resultUnit) {
        if (powerSamplesNeeded < 0) {
            throw new IllegalArgumentException("Calculation cannot depend on " + powerSamplesNeeded + " power samples.");
        }
        if (energySamplesNeeded < 0) {
            throw new IllegalArgumentException("Calculation cannot depend on " + energySamplesNeeded + " energy samples.");
        }
        if (numberOfInitSteps < 0) {
            throw new IllegalArgumentException("Calculation cannot have less than 0 init steps.");
        }
        if (resultUnit == null) {
            throw new IllegalArgumentException("Given result unit must not be null.");
        }
        this.powerSamplesRequiredForCalc = new CircularDataContainer(powerSamplesNeeded);
        this.energySamplesRequiredForCalc = new CircularDataContainer(energySamplesNeeded);
        this.numberOfInitSteps = numberOfInitSteps;
        this.calculatedEnergySamples = 0;
        this.resultUnit = resultUnit;
        this.setSamplingPeriod(samplingPeriod);
        this.setOffset(initialOffset);
    }

    protected AbstractCumulativeEnergyCalculator(int powerSamplesNeeded, int energySamplesNeeded, int numberOfInitSteps, Measurable<Duration> samplingPeriod, Measurable<Duration> initialOffset) {
        this(powerSamplesNeeded, energySamplesNeeded, numberOfInitSteps, samplingPeriod, initialOffset, AbstractCumulativeEnergyCalculator.getDefaultResultUnit());
    }

    protected AbstractCumulativeEnergyCalculator(int powerSamplesNeeded, int energySamplesNeeded, int numberOfInitSteps) {
        this(powerSamplesNeeded, energySamplesNeeded, numberOfInitSteps, (Measurable<Duration>)DEFAULT_SAMPLING_PERIOD, (Measurable<Duration>)ZERO_DURATION, AbstractCumulativeEnergyCalculator.getDefaultResultUnit());
    }

    public void reset() {
        this.calculatedEnergySamples = 0;
        this.energySamplesRequiredForCalc.clear();
        this.powerSamplesRequiredForCalc.clear();
        this.initialOffset = ZERO_DURATION;
        this.samplingPeriod = DEFAULT_SAMPLING_PERIOD;
    }

    private void setSamplingPeriod(Amount<Duration> samplingPeriod) {
        if (!samplingPeriod.isGreaterThan(ZERO_DURATION)) {
            throw new IllegalArgumentException("Sampling period, e.g., the window increment, must be positive.");
        }
        this.samplingPeriod = samplingPeriod;
    }

    public void setSamplingPeriod(Measurable<Duration> samplingPeriod) {
        if (samplingPeriod == null) {
            throw new IllegalArgumentException("Sampling period must not be null.");
        }
        this.setSamplingPeriod((Amount<Duration>)Amount.valueOf((double)samplingPeriod.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND));
    }

    private void setOffset(Amount<Duration> initialOffset) {
        if (initialOffset.isLessThan(ZERO_DURATION)) {
            throw new IllegalArgumentException("Initial offset, e.g., the window length, must be >= 0.");
        }
        this.initialOffset = initialOffset;
    }

    public void setOffset(Measurable<Duration> initialOffset) {
        if (initialOffset == null) {
            throw new IllegalArgumentException("Given initial offset must not be null.");
        }
        this.setOffset((Amount<Duration>)Amount.valueOf((double)initialOffset.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND));
    }

    public Amount<Duration> getInitialOffset() {
        return this.initialOffset;
    }

    public Amount<Duration> getSamplingPeriod() {
        return this.samplingPeriod;
    }

    public Unit<Energy> getResultUnit() {
        return this.resultUnit;
    }

    public static Unit<Energy> getDefaultResultUnit() {
        return PowerModelConstants.WATT_HOURS;
    }

    public final Amount<Energy> calculateNext(Measurable<Power> newPowerSample) {
        if (newPowerSample == null) {
            throw new IllegalArgumentException("Given power sample must not be null.");
        }
        Amount<Energy> result = null;
        this.powerSamplesRequiredForCalc.add((Amount<Power>)Amount.valueOf((double)newPowerSample.doubleValue((Unit)SI.WATT), (Unit)SI.WATT));
        result = this.calculatedEnergySamples < this.numberOfInitSteps ? this.calculateInitValue(this.calculatedEnergySamples + 1) : this.calculateNextInternal();
        ++this.calculatedEnergySamples;
        this.energySamplesRequiredForCalc.add(result);
        return result.to(this.resultUnit);
    }

    protected abstract Amount<Energy> calculateNextInternal();

    protected abstract Amount<Energy> calculateInitValue(int var1);

    protected int getCurrentlyStoredPowerSamplesCount() {
        return this.powerSamplesRequiredForCalc.size();
    }

    protected int getCurrentlyStoredEnergySamplesCount() {
        return this.energySamplesRequiredForCalc.size();
    }

    protected Amount<Energy> getOldestEnergySample() {
        return this.energySamplesRequiredForCalc.getOldestElement();
    }

    protected Amount<Energy> getEnergySample(int index) {
        if (index < 0 || !this.energySamplesRequiredForCalc.isEmpty() && index > this.energySamplesRequiredForCalc.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (this.energySamplesRequiredForCalc.isEmpty()) {
            return null;
        }
        return this.energySamplesRequiredForCalc.get(this.energySamplesRequiredForCalc.size() - 1 - index);
    }

    protected Amount<Power> getOldestPowerSample() {
        return this.powerSamplesRequiredForCalc.getOldestElement();
    }

    protected Amount<Power> getPowerSample(int index) {
        if (index < 0 || !this.powerSamplesRequiredForCalc.isEmpty() && index > this.powerSamplesRequiredForCalc.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (this.powerSamplesRequiredForCalc.isEmpty()) {
            return null;
        }
        return this.powerSamplesRequiredForCalc.get(this.powerSamplesRequiredForCalc.size() - 1 - index);
    }

    protected Amount<Power> getMostRecentPowerSample() {
        return this.getPowerSample(0);
    }

    protected Amount<Energy> getMostRecentEnergySample() {
        return this.getEnergySample(0);
    }

    private static final class CircularDataContainer<T> {
        private final T[] data;
        private int oldestElementPointer = 0;
        private int currentElementCount = 0;

        private CircularDataContainer(int size) {
            assert (size > 0);
            Object[] tmp = new Object[size];
            this.data = tmp;
        }

        public int size() {
            return this.currentElementCount;
        }

        public int maxSize() {
            return this.data.length;
        }

        public boolean isEmpty() {
            return this.currentElementCount == 0;
        }

        public boolean add(T e) {
            if (this.size() == this.maxSize()) {
                this.removeOldestElement();
            }
            int index = this.oldestElementPointer + this.currentElementCount;
            this.data[index %= this.maxSize()] = e;
            ++this.currentElementCount;
            return true;
        }

        public T getOldestElement() {
            return this.data[this.oldestElementPointer];
        }

        public boolean removeOldestElement() {
            if (!this.isEmpty()) {
                this.data[this.oldestElementPointer] = null;
                this.adjustOldestElementPointer();
                --this.currentElementCount;
            }
            return true;
        }

        private void adjustOldestElementPointer() {
            ++this.oldestElementPointer;
            this.oldestElementPointer %= this.maxSize();
            assert (this.oldestElementPointer >= 0 && this.oldestElementPointer < this.maxSize());
        }

        public void clear() {
            Arrays.fill(this.data, null);
            this.currentElementCount = 0;
            this.oldestElementPointer = 0;
        }

        public T get(int index) {
            assert (index >= 0);
            return this.data[(this.oldestElementPointer + index) % this.maxSize()];
        }
    }
}

