/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.tests;

import de.fzi.power.interpreter.EvaluationScope;
import de.fzi.power.interpreter.EvaluationScopeIterator;
import de.fzi.power.interpreter.measureprovider.utilization.UtilizationFilterMeasureProvider;
import de.fzi.power.interpreter.tests.utils.MockStateOfActiveResourceTupleDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jscience.physics.amount.Amount;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.experimentanalysis.utilizationfilter.UtilizationFilterConfiguration;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;

public class EvaluationScopeTest {
    private static final MetricSetDescription expectedOutputDataMetric = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE;
    private static final MetricDescription expectedUtilizationMetric = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE;
    private static final double DELTA = Math.pow(10.0, -12.0);
    private static final Amount<Duration> ZERO_DURATION = Amount.valueOf((long)0L, (Unit)SI.SECOND);
    private EvaluationScope scope;
    private ProcessingResourceSpecification cpu;
    private ActiveResourceMeasuringPoint cpuMeasuringPoint;
    private ProcessingResourceSpecification hdd;
    private ActiveResourceMeasuringPoint hddMeasuringPoint;
    private UtilizationFilterConfiguration config;
    private Amount<Duration> windowLengthAmount;
    private List<IDataSource> scopeInputDatasources;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.scopeInputDatasources = new LinkedList<IDataSource>();
        this.config = new UtilizationFilterConfiguration();
        this.windowLengthAmount = Amount.valueOf((double)this.config.getWindowLength().doubleValue(this.config.getWindowLength().getUnit()), (Unit)this.config.getWindowLength().getUnit());
        this.hdd = ResourceenvironmentFactory.eINSTANCE.createProcessingResourceSpecification();
        this.hdd.setId("HDD");
        this.cpu = ResourceenvironmentFactory.eINSTANCE.createProcessingResourceSpecification();
        this.cpu.setId("CPU");
        this.cpuMeasuringPoint = PcmmeasuringpointFactory.eINSTANCE.createActiveResourceMeasuringPoint();
        this.cpuMeasuringPoint.setActiveResource(this.cpu);
        this.hddMeasuringPoint = PcmmeasuringpointFactory.eINSTANCE.createActiveResourceMeasuringPoint();
        this.hddMeasuringPoint.setActiveResource(this.hdd);
        MockStateOfActiveResourceTupleDataSource cpuInputStream = new MockStateOfActiveResourceTupleDataSource((Measure<Double, Duration>)this.config.getWindowLength(), (MeasuringPoint)this.cpuMeasuringPoint);
        cpuInputStream.createData75PercentUtilization(ZERO_DURATION);
        cpuInputStream.createData50PercentUtilization((Amount<Duration>)ZERO_DURATION.plus(this.windowLengthAmount));
        MockStateOfActiveResourceTupleDataSource hddInputStream = new MockStateOfActiveResourceTupleDataSource((Measure<Double, Duration>)this.config.getWindowLength(), (MeasuringPoint)this.hddMeasuringPoint);
        hddInputStream.createData50PercentUtilization(ZERO_DURATION);
        hddInputStream.createData75PercentUtilization((Amount<Duration>)ZERO_DURATION.plus(this.windowLengthAmount));
        this.scopeInputDatasources.add((IDataSource)cpuInputStream);
        this.scopeInputDatasources.add((IDataSource)hddInputStream);
        UtilizationFilterMeasureProvider prov = new UtilizationFilterMeasureProvider();
        HashMap<String, Measure> filterProperties = new HashMap<String, Measure>(prov.getProperties());
        filterProperties.put("windowIncrement", this.config.getWindowIncrement());
        filterProperties.put("windowLength", this.config.getWindowLength());
        prov.setProperties(filterProperties);
        this.scope = EvaluationScope.createScope(this.scopeInputDatasources, Collections.singleton(prov));
        HashMap<ProcessingResourceSpecification, Set<MetricSetDescription>> desiredMetrics = new HashMap<ProcessingResourceSpecification, Set<MetricSetDescription>>(2);
        desiredMetrics.put(this.cpu, Collections.singleton(expectedOutputDataMetric));
        desiredMetrics.put(this.hdd, Collections.singleton(expectedOutputDataMetric));
        this.scope.setResourceMetricsToEvaluate(desiredMetrics);
    }

    @Test
    public void testCreateEvaluationScopeNullMeasure() {
        this.expectedException.expect(IllegalArgumentException.class);
        UtilizationFilterMeasureProvider prov = new UtilizationFilterMeasureProvider();
        HashMap<String, Measure> filterProperties = new HashMap<String, Measure>(prov.getProperties());
        filterProperties.put("windowIncrement", null);
        filterProperties.put("windowLength", this.config.getWindowLength());
        prov.setProperties(filterProperties);
    }

    @Test
    public void testCreateEvaluationScopeNegativeDurationMeasure() {
        UtilizationFilterMeasureProvider prov = new UtilizationFilterMeasureProvider();
        this.expectedException.expect((Matcher)new BaseMatcher<Object>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return item instanceof UndeclaredThrowableException && ((UndeclaredThrowableException)item).getUndeclaredThrowable() instanceof InvocationTargetException && ((InvocationTargetException)((UndeclaredThrowableException)item).getUndeclaredThrowable()).getTargetException() instanceof IllegalArgumentException;
            }
        });
        HashMap<String, Measure> filterProperties = new HashMap<String, Measure>(prov.getProperties());
        filterProperties.put("windowIncrement", this.config.getWindowIncrement());
        filterProperties.put("windowLength", Measure.valueOf((double)-5.0, (Unit)NonSI.HOUR));
        prov.setProperties(filterProperties);
    }

    @Test
    public void testGetMeasurementsForProcessingResource() {
        Iterator actual = this.scope.getMeasurementsForProcessingResource(this.cpu, expectedUtilizationMetric);
        Assert.assertTrue((boolean)actual.hasNext());
        TupleMeasurement expectedCpuUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.75, (Unit)Unit.ONE)});
        Measure expected = expectedCpuUtilization.getMeasureForMetric(expectedUtilizationMetric);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)actual.next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
        Assert.assertTrue((boolean)actual.hasNext());
        expectedCpuUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.5, (Unit)Unit.ONE)});
        expected = expectedCpuUtilization.getMeasureForMetric(expectedUtilizationMetric);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)actual.next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
        Assert.assertFalse((boolean)actual.hasNext());
    }

    @Test
    public void testIteratorNoSuchElementException() {
        EvaluationScopeIterator it = this.scope.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        this.expectedException.expect(NoSuchElementException.class);
        it.next();
    }

    @Test
    public void testIteratorRemoveUnsupportedOperationException() {
        EvaluationScopeIterator it = this.scope.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        this.expectedException.expect(UnsupportedOperationException.class);
        it.remove();
    }

    @Test
    public void testGetFirstMeasurement() {
        this.scope.next();
        TupleMeasurement expectedCpuUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.75, (Unit)Unit.ONE)});
        Collection measurements = this.scope.getMeasurements(this.cpu);
        Measure expected = expectedCpuUtilization.getMeasureForMetric(expectedUtilizationMetric);
        Assert.assertEquals((long)measurements.size(), (long)1L);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)measurements.iterator().next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
        TupleMeasurement expectedHddUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.5, (Unit)Unit.ONE)});
        expected = expectedHddUtilization.getMeasureForMetric(expectedUtilizationMetric);
        measurements = this.scope.getMeasurements(this.hdd);
        Assert.assertEquals((long)measurements.size(), (long)1L);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)measurements.iterator().next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
    }

    @Test
    public void testGetSecondMeasurement() {
        this.scope.next();
        this.scope.next();
        TupleMeasurement expectedCpuUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.5, (Unit)Unit.ONE)});
        Collection measurements = this.scope.getMeasurements(this.cpu);
        Measure expected = expectedCpuUtilization.getMeasureForMetric(expectedUtilizationMetric);
        Assert.assertEquals((long)measurements.size(), (long)1L);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)measurements.iterator().next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
        TupleMeasurement expectedHddUtilization = new TupleMeasurement(expectedOutputDataMetric, new Measure[]{this.config.getWindowLength(), Measure.valueOf((double)0.75, (Unit)Unit.ONE)});
        expected = expectedHddUtilization.getMeasureForMetric(expectedUtilizationMetric);
        measurements = this.scope.getMeasurements(this.hdd);
        Assert.assertEquals((long)measurements.size(), (long)1L);
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)((MeasuringValue)measurements.iterator().next()).getMeasureForMetric(expectedUtilizationMetric).getValue()), (double)DELTA);
    }
}

