/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.tests;

import de.fzi.power.binding.BindingFactory;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.infrastructure.InfrastructureFactory;
import de.fzi.power.infrastructure.PowerConsumingResource;
import de.fzi.power.interpreter.calculators.essential.LinearPowerModelCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.HashSet;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class LinearPowerModelCalculatorTest {
    private PowerConsumingResource resource;
    private ResourcePowerBinding binding;
    private FixedFactorValuePower idleConsumption;
    private FixedFactorValuePower maxConsumption;
    private LinearPowerModelCalculator calculatorUnderTest;

    @Before
    public void setUp() {
        this.resource = InfrastructureFactory.eINSTANCE.createPowerConsumingResource();
        this.binding = BindingFactory.eINSTANCE.createResourcePowerBinding();
        this.binding.setResourcePowerModelSpecification(PowerModelConstants.LINEAR_POWER_MODEL);
        this.resource.setResourcePowerAssemblyContext(this.binding);
        this.idleConsumption = BindingFactory.eINSTANCE.createFixedFactorValuePower();
        this.idleConsumption.setBoundFactor(PowerModelConstants.LINEAR_POWER_MODEL_MIN_CONSUMPTION);
        this.idleConsumption.setValue(Measure.valueOf((double)200.0, (Unit)SI.WATT));
        this.binding.getFixedFactorValues().add((Object)this.idleConsumption);
        this.maxConsumption = BindingFactory.eINSTANCE.createFixedFactorValuePower();
        this.maxConsumption.setBoundFactor(PowerModelConstants.LINEAR_POWER_MODEL_MAX_CONSUMPTION);
        this.maxConsumption.setValue(Measure.valueOf((double)400.0, (Unit)SI.WATT));
        this.binding.getFixedFactorValues().add((Object)this.maxConsumption);
        this.calculatorUnderTest = new LinearPowerModelCalculator(this.resource.getResourcePowerAssemblyContext());
    }

    @Test
    public void testCalculate() {
        this.testUtilization(0.0);
        this.testUtilization(0.5);
        this.testUtilization(1.0);
    }

    private void testUtilization(double utilizationValue) {
        HashSet<MeasuringValue> input = new HashSet<MeasuringValue>();
        input.add(this.createUtilizationTupleMeasurement(utilizationValue));
        Amount resLowUtil = this.calculatorUnderTest.calculate(input);
        Assert.assertTrue((boolean)resLowUtil.approximates(Amount.valueOf((double)200.0, (Unit)SI.WATT).times(utilizationValue).plus(Amount.valueOf((double)200.0, (Unit)SI.WATT))));
    }

    private MeasuringValue createUtilizationTupleMeasurement(double utilizationValue) {
        return new BasicMeasurement(Measure.valueOf((double)utilizationValue, (Unit)Unit.ONE), MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE);
    }
}

