/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.tests;

import de.fzi.power.binding.PowerBindingRepository;
import de.fzi.power.infrastructure.MountedPowerDistributionUnit;
import de.fzi.power.infrastructure.PowerConsumingResource;
import de.fzi.power.infrastructure.PowerDistributionUnit;
import de.fzi.power.infrastructure.PowerInfrastructureRepository;
import de.fzi.power.interpreter.AbstractEvaluationScope;
import de.fzi.power.interpreter.ConsumptionContext;
import de.fzi.power.interpreter.EvaluationScope;
import de.fzi.power.interpreter.PowerConsumptionSwitch;
import de.fzi.power.interpreter.PowerModelRegistry;
import de.fzi.power.interpreter.PowerModelUpdaterSwitch;
import de.fzi.power.interpreter.calculators.CalculatorInstantiator;
import de.fzi.power.interpreter.calculators.ExtensibleCalculatorInstantiatorImpl;
import de.fzi.power.interpreter.measureprovider.utilization.UtilizationFilterMeasureProvider;
import de.fzi.power.interpreter.tests.utils.MockStateOfActiveResourceTupleDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jscience.physics.amount.Amount;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;

public class PowerConsumptionSwitchTest {
    private static final String BINDING_REPO_LOCATION = "platform:/plugin/de.fzi.power.interpreter.tests/resources/testBinding.binding";
    private static final String INFRASTRUCTURE_REPO_LOCATION = "platform:/plugin/de.fzi.power.interpreter.tests/resources/testInfrastructure.infrastructure";
    private PowerConsumptionSwitch switchUnderTest;
    private EvaluationScope evaluationScope;
    private Measure<Double, Duration> windowLength;
    private ConsumptionContext context;
    private PowerBindingRepository powerBindingRepo;
    private PowerInfrastructureRepository infrastructureRepo;
    private PowerDistributionUnit rootPdu;
    private MountedPowerDistributionUnit mountedPdu;
    private MountedPowerDistributionUnit nestedMountedPdu1;
    private MountedPowerDistributionUnit nestedMountedPdu2;
    private PowerConsumingResource cpu1;
    private PowerConsumingResource cpu2;
    private PowerModelRegistry modelRegistry;
    private ActiveResourceMeasuringPoint cpu1MeasuringPoint;
    private ActiveResourceMeasuringPoint cpu2MeasuringPoint;
    private MockStateOfActiveResourceTupleDataSource measurementsCpu1;
    private MockStateOfActiveResourceTupleDataSource measurementsCpu2;
    private static Resource bindingResource;
    private static Resource infrastructureResource;
    private static final double DELTA;
    private static final Amount<Duration> ZERO_DURATION;

    static {
        DELTA = Math.pow(10.0, -12.0);
        ZERO_DURATION = Amount.valueOf((long)0L, (Unit)SI.SECOND);
    }

    @BeforeClass
    public static void setupBeforeClass() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        bindingResource = resourceSet.createResource(URI.createURI((String)BINDING_REPO_LOCATION, (boolean)true));
        try {
            bindingResource.load(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        infrastructureResource = resourceSet.createResource(URI.createURI((String)INFRASTRUCTURE_REPO_LOCATION, (boolean)true));
        try {
            infrastructureResource.load(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() {
        try {
            bindingResource.delete(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            infrastructureResource.delete(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.powerBindingRepo = (PowerBindingRepository)bindingResource.getEObject("_Ey4nUETHEeSB-oPaAunQcg");
        this.rootPdu = (PowerDistributionUnit)infrastructureResource.getEObject("_98ByQEWMEeSZH5zlL3RMGg");
        this.infrastructureRepo = this.rootPdu.getPowerInfrastructureModel();
        EList nestedPces = this.rootPdu.getNestedPowerConsumingEntities();
        this.mountedPdu = (MountedPowerDistributionUnit)nestedPces.get(0);
        this.nestedMountedPdu2 = (MountedPowerDistributionUnit)nestedPces.get(1);
        this.nestedMountedPdu1 = (MountedPowerDistributionUnit)this.mountedPdu.getNestedPowerConsumingEntities().get(0);
        this.cpu1 = (PowerConsumingResource)this.nestedMountedPdu1.getNestedPowerConsumingEntities().get(0);
        this.cpu2 = (PowerConsumingResource)this.nestedMountedPdu2.getNestedPowerConsumingEntities().get(0);
        this.windowLength = Measure.valueOf((double)10.0, (Unit)SI.SECOND);
        this.cpu1MeasuringPoint = PcmmeasuringpointFactory.eINSTANCE.createActiveResourceMeasuringPoint();
        this.cpu1MeasuringPoint.setActiveResource(this.cpu1.getProcessingResourceSpecification());
        this.cpu2MeasuringPoint = PcmmeasuringpointFactory.eINSTANCE.createActiveResourceMeasuringPoint();
        this.cpu2MeasuringPoint.setActiveResource(this.cpu2.getProcessingResourceSpecification());
        this.measurementsCpu1 = new MockStateOfActiveResourceTupleDataSource(this.windowLength, (MeasuringPoint)this.cpu1MeasuringPoint);
        this.measurementsCpu2 = new MockStateOfActiveResourceTupleDataSource(this.windowLength, (MeasuringPoint)this.cpu2MeasuringPoint);
        this.modelRegistry = new PowerModelRegistry();
        new PowerModelUpdaterSwitch(this.modelRegistry, (CalculatorInstantiator)new ExtensibleCalculatorInstantiatorImpl()).doSwitch((EObject)this.infrastructureRepo);
    }

    private void initializeSwitch() {
        ArrayList<MockStateOfActiveResourceTupleDataSource> datasources = new ArrayList<MockStateOfActiveResourceTupleDataSource>();
        datasources.add(this.measurementsCpu1);
        datasources.add(this.measurementsCpu2);
        UtilizationFilterMeasureProvider prov = new UtilizationFilterMeasureProvider();
        HashMap<String, Measure<Double, Duration>> filterProperties = new HashMap<String, Measure<Double, Duration>>(prov.getProperties());
        filterProperties.put("windowIncrement", this.windowLength);
        filterProperties.put("windowLength", this.windowLength);
        prov.setProperties(filterProperties);
        this.evaluationScope = EvaluationScope.createScope(datasources, Collections.singleton(prov));
        this.context = ConsumptionContext.createConsumptionContext((PowerBindingRepository)this.powerBindingRepo, (AbstractEvaluationScope)this.evaluationScope, (PowerModelRegistry)this.modelRegistry);
        this.switchUnderTest = PowerConsumptionSwitch.createPowerConsumptionSwitch((ConsumptionContext)this.context);
        this.evaluationScope.next();
    }

    @Test
    public void testPowerAtRootPdu() {
        this.measurementsCpu1.createData100PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData100PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.rootPdu);
        Amount expected = Amount.valueOf((double)600.0, (Unit)SI.WATT).plus(Amount.valueOf((double)300.0, (Unit)SI.WATT));
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtMountedPdu() {
        this.measurementsCpu1.createData100PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData100PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.mountedPdu);
        Amount expected = Amount.valueOf((double)600.0, (Unit)SI.WATT);
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtRepo() {
        this.measurementsCpu1.createData50PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData50PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.infrastructureRepo);
        Amount expected = Amount.valueOf((double)500.0, (Unit)SI.WATT).plus(Amount.valueOf((double)250.0, (Unit)SI.WATT));
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtNestedMountedPdu2() {
        this.measurementsCpu1.createData75PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData75PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.nestedMountedPdu2);
        Amount expected = Amount.valueOf((double)275.0, (Unit)SI.WATT);
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtCpu2() {
        this.measurementsCpu1.createData75PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData75PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.cpu2);
        Amount expected = Amount.valueOf((double)275.0, (Unit)SI.WATT);
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtNestedMountedPdu1() {
        this.measurementsCpu1.createData25PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData25PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.nestedMountedPdu1);
        Amount expected = Amount.valueOf((double)450.0, (Unit)SI.WATT);
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }

    @Test
    public void testPowerAtCpu1() {
        this.measurementsCpu1.createData25PercentUtilization(ZERO_DURATION);
        this.measurementsCpu2.createData25PercentUtilization(ZERO_DURATION);
        this.initializeSwitch();
        Amount actual = (Amount)this.switchUnderTest.doSwitch((EObject)this.nestedMountedPdu1);
        Amount expected = Amount.valueOf((double)450.0, (Unit)SI.WATT);
        Assert.assertEquals((double)expected.doubleValue((Unit)SI.WATT), (double)actual.doubleValue((Unit)SI.WATT), (double)DELTA);
    }
}

